(function ($, _, Backbone, api, settings) {

	happyForms.classes.models.parts.mailchimp = happyForms.classes.models.Part.extend( {
		defaults: function () {
			return _.extend(
				{},
				settings.formParts.mailchimp.defaults,
				_.result( happyForms.classes.models.Part.prototype, 'defaults' ),
			);
		},
	} );

	happyForms.classes.views.parts.mailchimp = happyForms.classes.views.Part.extend( {
		template: '#happyforms-customize-mailchimp-template',
		editor: null,

		ready: function () {
			happyForms.classes.views.Part.prototype.ready.apply(this, arguments);

			this.listenTo(this, 'refresh', this.onRefresh);

			this.initEditor();
		},

		initEditor: function() {
			var $textarea = $('textarea[name=mailchimp_text]', this.$el);
			var editorId = $textarea.attr('id');
			var editorSettings = {
				tinymce: {
					toolbar1: 'bold,italic,bullist,numlist,link,hr',
					setup: this.onEditorInit.bind(this)
				},
			};

			wp.editor.initialize(editorId, editorSettings);
		},

		removeEditor: function() {
			var $textarea = $('textarea[name=mailchimp_text]', this.$el);
			var editorId = $textarea.attr('id');

			wp.editor.remove( editorId );
		},

		onRefresh: function () {
			this.removeEditor();
			this.initEditor();
		},

		/**
		 * Triggere previewer event on each `keyup` and `change` event in the WP editor.
		 *
		 * @since 1.0.0.
		 *
		 * @param {object} editor TinyMCE editor JS object.
		 *
		 * @return void
		 */
		onEditorInit: function ( editor ) {
			editor.on('keyup change', function () {
				this.model.set('mailchimp_text', editor.getContent());

				var data = {
					id: this.model.get('id'),
					callback: 'onMailchimpTextChange',
				};

				happyForms.previewSend('happyforms-part-dom-update', data);
			}.bind( this ) );
		},

		/**
		 * Add a special treatment for removing WP editor when the part is removed.
		 *
		 * @since 1.0.0.
		 *
		 * @return void
		 */
		remove: function () {
			var $textarea = $('textarea[name=mailchimp_text]', this.$el);
			var editorId = $textarea.attr('id');

			wp.editor.remove(editorId);

			happyForms.classes.views.Part.prototype.remove.apply(this, arguments);
		}
	} );

	happyForms.previewer = _.extend( happyForms.previewer, {
		onMailchimpTextChange: function (id, html, options) {
			var part = this.getPartModel(id);
			var $part = this.getPartElement(html);

			this.$( '.happyforms-part__el .label', $part ).html( part.get( 'mailchimp_text' ) );
		},
	} );

	var FormBuild = happyForms.classes.views.FormBuild;

	happyForms.classes.views.FormBuild = FormBuild.extend( {
		ready: function() {
			FormBuild.prototype.ready.apply( this, arguments );

			var mailchimpPart = happyForms.form.get( 'parts' ).findWhere( { type: 'mailchimp' } );

			if ( mailchimpPart ) {
				this.drawer.$el.addClass( 'has-mailchimp-part' );
			}
		},

		onPartAdd: function( type, options ) {
			if ( 'mailchimp' === type ) {
				var mailchimpPart = happyForms.form.get( 'parts' ).findWhere( { type: 'mailchimp' } );

				if ( mailchimpPart ) {
					return;
				}

				this.drawer.$el.addClass( 'has-mailchimp-part' );
			}

			FormBuild.prototype.onPartAdd.apply( this, arguments );
		},

		onPartModelRemove: function( model ) {
			FormBuild.prototype.onPartModelRemove.apply( this, arguments );

			if ( 'mailchimp' === model.get( 'type' ) ) {
				this.drawer.$el.removeClass( 'has-mailchimp-part' );
			}
		}
	} );

} )( jQuery, _, Backbone, wp.customize, _happyFormsSettings );
