<?php
if ( ! function_exists( 'happyforms_upgrade_template_path' ) ) :

function happyforms_upgrade_template_path( $path, $form = array(), $part = array() ) {
	$path = apply_filters( 'happyforms_get_upgrade_template_path', $path, $form, $part );
	$path = "/templates/{$path}.php";
	$path = happyforms_get_include_folder() . $path;

	return $path;
}

endif;

if ( ! function_exists( 'happyforms_password_submit' ) ) :

function happyforms_password_submit( $form ) {
	include( happyforms_upgrade_template_path( 'partials/form-password-submit', $form ) );
}

endif;

if ( ! function_exists( 'happyforms_get_client_ip' ) ) :

function happyforms_get_client_ip() {
	$keys = array( 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR' );

	foreach( $keys as $key ) {
		if ( isset( $_SERVER[$key] ) && ! empty( $_SERVER[$key] ) ) {
			return $_SERVER[$key];
		}
	}

	return '';
}

endif;

if ( ! function_exists( 'happyforms_get_client_user_agent' ) ) :

function happyforms_get_client_user_agent() {
	$key = 'HTTP_USER_AGENT';

	if ( isset( $_SERVER[$key] ) && ! empty( $_SERVER[$key] ) ) {
		return $_SERVER[$key];
	}

	return '';
}

endif;

if ( ! function_exists( 'happyforms_get_current_url' ) ) :

function happyforms_get_current_url() {
	$protocol = isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http';
	$host = $_SERVER['HTTP_HOST'];
	$uri = $_SERVER['REQUEST_URI'];
	$url = $protocol . '://' . $host . $uri;

	return $url;
}

endif;

if ( ! function_exists( 'happyforms_get_referer' ) ) :

function happyforms_get_referer() {
	$key = 'HTTP_REFERER';

	if ( isset( $_SERVER[$key] ) && ! empty( $_SERVER[$key] ) ) {
		return $_SERVER[$key];
	}

	return '';
}

endif;

if ( ! function_exists( 'happyforms_form_is_available' ) ) :

function happyforms_form_is_available( $form ) {
	$available = true;

	$available = $available && ( ! happyforms_get_schedule()->is_restricted( $form ) );

	return $available;
}

endif;

if ( ! function_exists( 'happyforms_get_page_breaks' ) ) :

function happyforms_get_page_breaks( $form ) {
	$breaks = happyforms_get_form_controller()->get_parts_by_type( $form, 'page_break' );
	$breaks = wp_list_pluck( $breaks, 'id' );

	return $breaks;
}

endif;

if ( ! function_exists( 'happyforms_get_current_page_break' ) ) :

function happyforms_get_current_page_break( $form, $index = false ) {
	$step = happyforms_get_current_step( $form );
	$breaks = happyforms_get_page_breaks( $form );

	if ( ! in_array( $step, $breaks ) ) {
		return false;
	}

	if ( true === $index ) {
		$step = array_search( $step, $breaks );
	}

	return $step;
}

endif;


if ( ! function_exists( 'happyforms_get_poll_votes_label' ) ) :

function happyforms_get_poll_votes_label( $votes_number ) {
	$label = __( 'votes', 'happyforms' );

	if ( 1 === intval( $votes_number ) ) {
		$label = __( 'vote', 'happyforms' );
	}

	return $label;
}

endif;

if ( ! function_exists( 'happyforms_submit_enabled' ) ) :

function happyforms_submit_enabled( $form ) {
	$disabled = happyforms_get_form_property( $form, 'disable_submit_until_valid' );
	$preview = happyforms_is_preview_context();
	return $disabled || $preview;
}

endif;

if ( ! function_exists( 'happyforms_get_part_choice_letter' ) ) :

function happyforms_get_part_choice_letter( $option, $part ) {
	$letters = range( 'A', 'Z' );

	if ( ! empty( $option ) ) {
		$option_index = array_search( $option['id'], array_column( $part['options'], 'id' ) );
		$letter = $letters[$option_index];
	} else {
		$options_count = count( $part['options'] );
		$letter = $letters[$options_count];
	}

	return $letter;
}

endif;

if ( ! function_exists( 'happyforms_geolocation_button' ) ) :

function happyforms_geolocation_button( $part ) {
	?>
	<button class="happyforms-plain-button happyforms-address-geolocate happyforms-address-geolocate--default">
		<span class="screen-reader-text"><?php _e( 'Get location', 'happyforms' ); ?></span>
		<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24" class="happyforms-address-geolocate__crosshair"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm8.94 3c-.46-4.17-3.77-7.48-7.94-7.94V1h-2v2.06C6.83 3.52 3.52 6.83 3.06 11H1v2h2.06c.46 4.17 3.77 7.48 7.94 7.94V23h2v-2.06c4.17-.46 7.48-3.77 7.94-7.94H23v-2h-2.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></svg>

		<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="spinner" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="happyforms-address-geolocate__spinner"><path fill="currentColor" d="M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z" class=""></path></svg>
	</button>
	<?php
}

endif;

if ( ! function_exists( 'happyforms_phone_allows_multiple_conventions' ) ) :

function happyforms_phone_allow_multiple_conventions( $part ) {
	$allow_multiple = false;

	if ( 0 == $part['mask_allow_only_this_convention'] ) {
		$allow_multiple = true;
	}

	/**
	 * Handle back compatibility with previous control labeled "Allow all conventions".
	 */
	if ( isset( $part['mask_allow_all_countries'] ) ) {
		if ( 1 == $part['mask_allow_all_countries'] && 1 != $part['mask_allow_only_this_convention'] ) {
			$allow_multiple = true;
		} else {
			$allow_multiple = false;
		}
	}

	return $allow_multiple;
}

endif;

if ( ! function_exists( 'happyforms_rank_get_options' ) ) :

function happyforms_rank_get_options( $options_size, $values ) {
	$options_html = '';

	for( $index = 0; $index < $options_size; $index++ ) {
		$option_label = $index + 1;
		$class_disabled = in_array( $option_label, $values ) ? ' rank-choice-disable' : ' ';

		$options_html .= "<li data-option-id='' data-value='".$option_label."' data-label='' class='happyforms-dropdown-item happyforms-custom-select-dropdown__item".$class_disabled."'>".$option_label."</li>";
	}

	return $options_html;
}

endif;