<script type="text/template" id="happyforms-customize-phone-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p class="happyforms-placeholder-option" style="display: <%= ( 'as_placeholder' !== instance.label_placement ) ? 'block' : 'none' %>">
		<label for="<%= instance.id %>_placeholder"><?php _e( 'Placeholder', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_placeholder" class="widefat title" value="<%= instance.placeholder %>" data-bind="placeholder" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Description', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_phone_before_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'This is required', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_phone_after_options' ); ?>

	<div class="happyforms-part-advanced-settings-wrap">
		<?php do_action( 'happyforms_part_customize_phone_before_advanced_options' ); ?>

		<p>
			<label>
				<input type="checkbox" name="masked" class="checkbox" value="1" <% if ( instance.masked ) { %>checked="checked"<% } %> data-bind="masked" /> <?php _e( 'Use national convention', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings number-options number-options--phone" data-trigger="masked" style="display: <%= (instance.masked != 0) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_mask_phone_country"><?php _e( 'Default convention', 'happyforms' ); ?></label>
				<select id="<%= instance.id %>_mask_phone_country" class="widefat title" data-bind="mask_phone_country">
				<?php
				$phone_countries = happyforms_get_phone_countries();

				foreach ( $phone_countries as $country_code => $country ) : ?>
					<option value="<?php echo esc_attr( $country_code ); ?>"<% if (instance.mask_phone_country == <?php echo $country['code']; ?> || instance.mask_phone_country == '<?php echo $country_code; ?>') { %> selected<% } %>><?php echo ucwords( strtolower( $country['name'] ) ); ?></option>
				<?php endforeach; ?>
				</select>
			</p>
			<p>
				<label>
					<input type="checkbox" name="mask_allow_only_this_convention" class="checkbox" value="1" <% if ( instance.mask_allow_only_this_convention || ( 'undefined' !== typeof instance.mask_allow_all_countries && 0 == instance.mask_allow_all_countries ) ) { %>checked="checked"<% } %> data-bind="mask_allow_only_this_convention" /> <?php _e( 'Only allow this convention', 'happyforms' ); ?>
				</label>
			</p>
		</div>
		<p>
			<label>
				<input type="checkbox" class="checkbox confirmation-checkbox" value="1" <% if ( instance.confirmation_field ) { %>checked="checked"<% } %> data-bind="confirmation_field" /> <?php _e( 'Require confirmation', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings" data-trigger="confirmation_field" style="display: <%= (instance.confirmation_field == 1) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_confirmation_field_label"><?php _e( '\'Confirmation\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_confirmation_field_label" class="widefat title" value="<%= instance.confirmation_field_label %>" data-bind="confirmation_field_label" />
			</p>
			<p>
				<label for="<%= instance.id %>_confirmation_field_placeholder"><?php _e( '\'Confirmation\' placeholder', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_confirmation_field_placeholder" class="widefat title" value="<%= instance.confirmation_field_placeholder %>" data-bind="confirmation_field_placeholder" />
			</p>
		</div>

		<?php happyforms_customize_part_width_control(); ?>

		<p>
			<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
		</p>

		<?php do_action( 'happyforms_part_customize_phone_after_advanced_options' ); ?>
	</div>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
