<?php

class HappyForms_Integration_AWeber {

	private static $instance;
	private static $hooked = false;
	private $service;

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function __construct() {
		$this->service = happyforms_get_integrations()->get_service( 'aweber' );
	}

	public function hook() {
		add_filter( 'happyforms_meta_fields', array( $this, 'meta_fields' ) );
		add_filter( 'happyforms_email_controls', array( $this, 'setup_controls' ) );
		add_filter( 'happyforms_conditional_enabled_setup_controls', array( $this, 'conditional_enabled_setup_controls' ) );

		$supported_parts = $this->get_supported_parts();

		foreach ( $supported_parts as $part ) {
			add_filter( "happyforms_part_customize_fields_{$part}", array( $this, 'add_part_fields' ) );
			add_action( "happyforms_part_customize_{$part}_before_advanced_options", array( $this, 'add_part_controls' ) );
		}

		add_action( 'happyforms_customize_enqueue_scripts', array( $this, 'customize_enqueue_scripts' ) );
		add_action( 'happyforms_submission_success', array( $this, 'handle_submit' ), 10, 3 );
	}

	public function meta_fields( $fields ) {
		$fields['enable_aweber'] = array(
			'default' => 0,
			'sanitize' => 'happyforms_sanitize_checkbox'
		);

		$fields['aweber_list'] = array(
			'default' => 0,
			'sanitize' => 'sanitize_text_field'
		);

		$fields['aweber_tags'] = array(
			'default' => '',
			'sanitize' => 'sanitize_text_field'
		);

		return $fields;
	}

	public function setup_controls( $controls ) {
		$controls[150] = array(
			'type' => 'checkbox',
			'field' => 'enable_aweber',
			'label' => __( 'Use AWeber', 'happyforms' ),
			'tooltip' => __( 'Send mapped fields to AWeber.', 'happyforms' )
		);

		$controls[151] = array(
			'type' => 'group_start',
			'trigger' => 'enable_aweber'
		);

		$lists = $this->service->get_lists();
		$lists = wp_list_pluck( $lists, 'name', 'id' );

		$controls[152] = array(
			'type' => 'select',
			'field' => 'aweber_list',
			'placeholder' => __( '— Select —', 'happyforms' ),
			'label' => __( 'List to add user\'s email to', 'happyforms' ),
			'options' => $lists
		);

		$controls[153] = array(
			'type' => 'text',
			'field' => 'aweber_tags',
			'label' => __( 'Add these tags to submissions', 'happyforms' ),
			'placeholder' => __( 'e.g. Influencer, Prospect, Uses coupons', 'happyforms' )
		);

		$controls[154] = array(
			'type' => 'group_end'
		);

		return $controls;
	}

	public function conditional_enabled_setup_controls( $controls ) {
		$lists = $this->service->get_lists();
		$lists = wp_list_pluck( $lists, 'name', 'id' );

		$controls['aweber_list'] = array(
			'type' => 'select',
			'options' => $lists,
			'then_text' => __( 'Then add to…', 'happyforms' )
		);

		$controls['aweber_tags'] = array(
			'type' => 'set',
			'then_text' => __( 'Then add tags…', 'happyforms' )
		);

		return $controls;
	}

	public function get_supported_parts() {
		$parts = array(
			'single_line_text',
			'multi_line_text',
			'email',
			'website_url',
			'radio',
			'checkbox',
			'select',
			'number',
			'poll',
			'phone',
			'date',
			'scale',
			'rich_text',
			'title',
			'legal',
			'rating'
		);

		return $parts;
	}

	public function add_part_fields( $fields ) {
		$fields['aweber_field'] = array(
			'default' => '',
			'sanitize' => 'sanitize_text_field'
		);

		return $fields;
	}

	public function add_part_controls() {
		require( happyforms_get_integrations_folder() . '/services/aweber/templates/partial-part-controls.php' );
	}

	public function customize_enqueue_scripts() {
		$fields = $this->service->get_fields();

		$aweber_data = array(
			'fields' => $fields,
		);

		wp_localize_script(
			'happyforms-customize',
			'_happyFormsAweberSettings',
			$aweber_data
		);
	}

	public function handle_submit( $submission, $form, $message ) {
		$form_controller = happyforms_get_form_controller();
		$form = happyforms_get_conditional_controller()->get( $form, $_REQUEST );
		$list_id = happyforms_get_form_property( $form, 'aweber_list' );

		$email_integration_part = $form_controller->get_first_part_by_type( $form, 'email_integration' );

		if ( $email_integration_part && 'yes' !== $submission[$email_integration_part['id']] ) {
			return;
		}

		if ( '' === $list_id ) {
			return;
		}

		$supported_parts = $this->get_supported_parts();
		$parts = array_filter( $form['parts'], function( $part ) use( $supported_parts ) {
			$supported = ( 
				( in_array( $part['type'], $supported_parts ) ) 
				&& ( $part['aweber_field'] != '' )
			);

			return $supported;
		} );
		$fields = wp_list_pluck( $parts, 'id', 'aweber_field' );
		
		if ( ! isset( $fields['email'] ) ) {
			return;
		}

		unset( $fields[''] );

		foreach( $fields as $field => $part_id ) {
			$fields[$field] = $submission[$part_id];
		}

		$tags = happyforms_get_form_property( $form, 'aweber_tags' );
		$tags = explode( ',', $tags );
		$tags = array_map( 'trim', $tags );

		$this->service->add_subscriber( $list_id, $fields, $tags );
	}

}

if ( ! function_exists( 'happyforms_get_integration_aweber' ) ):

function happyforms_get_integration_aweber() {
	$instance = HappyForms_Integration_AWeber::instance();
	$instance->hook();

	return $instance;
}

endif;

happyforms_get_integration_aweber();
