<?php

if ( ! function_exists( 'happyforms_payment_part_has_user_price' ) ) :

function happyforms_payment_part_has_user_price( $part, $form ) {

}

endif;

if ( ! function_exists( 'happyforms_payment_part_has_credit_card' ) ) :

function happyforms_payment_part_has_credit_card( $part, $form ) {
	$has_credit_card = apply_filters( 'happyforms_payment_part_has_credit_card', false, $part, $form  );

	return $has_credit_card;
}

endif;

if ( ! function_exists( 'happyforms_payment_part_has_paypal' ) ) :

function happyforms_payment_part_has_paypal( $part, $form ) {
	$has_paypal = apply_filters( 'happyforms_payment_part_has_paypal', false, $part, $form  );

	return $has_paypal;
}

endif;


if ( ! function_exists( 'happyforms_payment_get_currencies' ) ) :

function happyforms_payment_get_currencies( $service = '' ) {
	$currencies = array(
		'aud' => array(
			'label' => __( 'Australian dollar (AUD)', 'happyforms' ),
			'symbol' => '$',
			'format' => 'float'
		),
		'thb' => array(
			'label' => __( 'Thai Baht (THB)', 'happyforms' ),
			'symbol' => '฿',
			'format' => 'float'
		),
		'brl' => array(
			'label' => __( 'Brazilian real (BRL)', 'happyforms' ),
			'symbol' => 'R$',
			'format' => 'float'
		),
		'cad' => array(
			'label' => __( 'Canadian dollar (CAD)', 'happyforms' ),
			'symbol' => '$',
			'format' => 'float'
		),
		'cny' => array(
			'label' => __( 'Chinese Renmenbi (CNY)', 'happyforms' ),
			'symbol' => '&yen;',
			'format' => 'float'
		),
		'czk' => array(
			'label' => __( 'Czech koruna (CZK)', 'happyforms' ),
			'symbol' => 'Kč',
			'format' => 'float'
		),
		'dkk' => array(
			'label' => __( 'Danish krone (DKK)', 'happyforms' ),
			'symbol' => 'kr.',
			'format' => 'float'
		),
		'eur' => array(
			'label' => __( 'Euro (EUR)', 'happyforms' ),
			'symbol' => '€',
			'format' => 'float'
		),
		'hkd' => array(
			'label' => __( 'Hong Kong dollar (HKD)', 'happyforms' ),
			'symbol' => 'HK$',
			'format' => 'float'
		),
		'huf' => array(
			'label' => __( 'Hungarian forint (HUF)', 'happyforms' ),
			'symbol' => 'Ft',
			'format' => 'float',
		),
		'inr' => array(
			'label' => __( 'Indian rupee (INR)', 'happyforms' ),
			'symbol' => '₹',
			'format' => 'float',
		),
		'ils' => array(
			'label' => __( 'Israeli new shekel (ILS)', 'happyforms' ),
			'symbol' => '₪',
			'format' => 'float',
		),
		'jpy' => array(
			'label' => __( 'Japanese yen (JPY)', 'happyforms' ),
			'symbol' => '¥',
			'format' => 'int'
		),
		'myr' => array(
			'label' => __( 'Malaysian ringgit (MYR)', 'happyforms' ),
			'symbol' => 'RM',
			'format' => 'float'
		),
		'mxn' => array(
			'label' => __( 'Mexican peso (MXN)', 'happyforms' ),
			'symbol' => '$',
			'format' => 'float'
		),
		'twd' => array(
			'label' => __( 'New Taiwan dollar (TWD)', 'happyforms' ),
			'symbol' => 'NT$',
			'format' => 'float'
		),
		'nzd' => array(
			'label' => __( 'New Zealand dollar (NZD)', 'happyforms' ),
			'symbol' => 'NZ$',
			'format' => 'float'
		),
		'nok' => array(
			'label' => __( 'Norwegian krone (NOK)', 'happyforms' ),
			'symbol' => 'kr',
			'format' => 'float'
		),
		'php' => array(
			'label' => __( 'Philippine peso (PHP)', 'happyforms' ),
			'symbol' => '₱',
			'format' => 'float'
		),
		'pln' => array(
			'label' => __( 'Polish złoty (PLN)', 'happyforms' ),
			'symbol' => 'zł',
			'format' => 'float'
		),
		'gbp' => array(
			'label' => __( 'Pound sterling (GBP)', 'happyforms' ),
			'symbol' => '£',
			'format' => 'float'
		),
		'rub' => array(
			'label' => __( 'Russian ruble (RUB)', 'happyforms' ),
			'symbol' => '₽',
			'format' => 'float'
		),
		'sgd' => array(
			'label' => __( 'Singapore dollar (SGD)', 'happyforms' ),
			'symbol' => '$',
			'format' => 'float'
		),
		'sek' => array(
			'label' => __( 'Swedish krona (SEK)', 'happyforms' ),
			'symbol' => 'Kr',
			'format' => 'float'
		),
		'chf' => array(
			'label' => __( 'Swiss franc (CHF)', 'happyforms' ),
			'symbol' => 'CHF',
			'format' => 'float'
		),
		'usd' => array(
			'label' => __( 'United States dollar (USD)', 'happyforms' ),
			'symbol' => '$',
			'format' => 'float'
		),
	);

	$currencies = apply_filters( 'happyforms_payment_currencies', $currencies, $service );

	return $currencies;
}

endif;

if ( ! function_exists( 'happyforms_payment_get_formatted_details' ) ) :

function happyforms_payment_get_formatted_details( $response_id ) {
	$transaction_details_meta = happyforms_get_payments_integration()->transaction_details_meta;
	$transaction_details = happyforms_get_meta( $response_id, $transaction_details_meta, true );

	if ( empty( $transaction_details ) ) {
		return '';
	}

	ob_start();
	do_action( 'happyforms_payment_the_transaction_details', $transaction_details );
	$details = ob_get_clean();

	return $details;
}

endif;
