<script type="text/template" id="happyforms-customize-payments-template">
	<?php
	$integrations = happyforms_get_integrations();
	$paypal = $integrations->get_service( 'paypal' );
	$stripe = $integrations->get_service( 'stripe' );
	?>

	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>

	<?php do_action( 'happyforms_part_customize_payments_before_options' ); ?>

	<p>
		<label for="<%= instance.id %>_label"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_label" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Description', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<p>
		<label for="<%= instance.id %>_currency"><?php _e( 'Currency', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_currency" data-bind="currency" class="widefat">
		<?php
		$currencies = happyforms_payment_get_currencies( 'stripe' );

		foreach( $currencies as $currency_key => $currency_data ) : ?>
			<option value="<?php echo $currency_key; ?>"<%= (instance.currency == '<?php echo $currency_key; ?>') ? ' selected' : '' %>><?php echo $currency_data['label']; ?></option>
		<?php endforeach; ?>
		</select>
	</p>

	<p class="price-field" style="display: <%= ( instance.show_user_price_field ) ? 'none' : 'block' %>">
		<label for="<%= instance.id %>_price"><?php _e( 'Price', 'happyforms' ); ?></label>
		<input type="number" min="0" id="<%= instance.id %>_price" class="widefat title" value="<%= instance.price %>" data-bind="price" />
	</p>

	<div class="happyforms-part-settings-logic-view" data-logic-type="set" data-logic-id="price" data-logic-then-text="<?php _e( 'Then price is…', 'happyforms' ); ?>" style="display: <%= ( instance.show_user_price_field ) ? 'none' : 'block' %>">
		<?php happyforms_customize_part_logic(); ?>
	</div>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'This is required', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_payments_after_options' ); ?>

	<div class="happyforms-part-advanced-settings-wrap">
		<?php do_action( 'happyforms_part_customize_payments_before_advanced_options' ); ?>

		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.show_user_price_field ) { %>checked="checked"<% } %> data-bind="show_user_price_field" /> <?php _e( 'Use \'pay what you want\' pricing', 'happyforms' ); ?>
			</label>
		</p>

		<div class="happyforms-nested-settings" data-trigger="show_user_price_field" style="display: <%= ( 1 == instance.show_user_price_field ) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_user_price_min"><?php _e( 'Minimum accepted amount', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_user_price_min" class="widefat title" value="<%= instance.user_price_min %>" data-bind="user_price_min" />
			</p>
			<p>
				<label for="<%= instance.id %>_user_price_label"><?php _e( 'Label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_user_price_label" class="widefat title" value="<%= instance.user_price_label %>" data-bind="user_price_label" />
			</p>
			<p>
				<label for="<%= instance.id %>_user_price_placeholder"><?php _e( 'Placeholder', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_user_price_placeholder" class="widefat title" value="<%= instance.user_price_placeholder %>" data-bind="user_price_placeholder" />
			</p>
		</div>

		<?php if ( $stripe->is_connected() && $paypal->is_connected() ) : ?>
			<p class="payment-method-choice-label">
				<label for="<%= instance.id %>_payment_method_choice_label"><?php _e( '\'Payment method\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_payment_method_choice_label" class="widefat title" value="<%= instance.payment_method_choice_label %>" data-bind="payment_method_choice_label" />
			</p>

			<p class="stripe-label">
				<label for="<%= instance.id %>_stripe_option_label"><?php _e( 'Stripe option label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_stripe_option_label" class="widefat title" value="<%= instance.stripe_option_label %>" data-bind="stripe_option_label" />
			</p>
		<?php endif; ?>

		<p>
			<label for="<%= instance.id %>_width"><?php _e( 'Width', 'happyforms' ); ?></label>
			<select id="<%= instance.id %>_width" name="width" data-bind="width" class="widefat">
				<option value="full"<%= (instance.width == 'full') ? ' selected' : '' %>><?php _e( 'Full', 'happyforms' ); ?></option>
				<option value="half"<%= (instance.width == 'half') ? ' selected' : '' %>><?php _e( 'Half', 'happyforms' ); ?></option>
				<option value="third"<%= (instance.width == 'third') ? ' selected' : '' %>><?php _e( 'Third', 'happyforms' ); ?></option>
				<option value="auto"<%= (instance.width == 'auto') ? ' selected' : '' %>><?php _e( 'Auto', 'happyforms' ); ?></option>
			</select>
		</p>
		<p class="width-options" style="display: none">
			<label>
				<input type="checkbox" class="checkbox apply-all-check" value="" data-apply-to="width" /> <?php _e( 'Apply to all fields', 'happyforms' ); ?>
			</label>
		</p>

		<?php do_action( 'happyforms_part_customize_payments_after_advanced_options' ); ?>

		<p>
			<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
		</p>
	</div>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<div class="happyforms-widget-actions">
		<a href="#" class="happyforms-form-part-remove"><?php _e( 'Delete', 'happyforms' ); ?></a>
		<a href="#" class="happyforms-form-part-advanced-settings"><?php _e( 'More', 'happyforms' ); ?></a>
		<a href="#" class="happyforms-form-part-logic"><?php _e( 'Logic', 'happyforms' ); ?></a>
	</div>
</script>
