<?php

class TTF_Product_Central_Updater {

	private static $instance;
	private $settings;
	private $products;
	private $api_url = 'https://api.thethemefoundry.com';

	public static function instance() {
		if ( is_null( self::$instance ) )
			self::$instance = new self();

		return self::$instance;
	}

	public function __construct() {
		require_once( happyforms_get_updater_folder() . '/class-product.php' );
		require_once( happyforms_get_updater_folder() . '/class-settings.php' );

		add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'get_updates' ) );
		add_filter( 'plugins_api', array( $this, 'get_info' ), 10, 3 );
		add_filter( 'http_request_args', array( $this, 'http_request_args' ), 20, 2 );
		add_action( 'admin_init', array( $this, 'check_authorization' ) );
		add_filter( 'upgrader_pre_download', array( $this, 'upgrader_pre_download' ), 10, 3 );
	}

	public function register( $product_data ) {
		$product = new TTF_Product_Central_Product( $product_data );
		$this->products[$product->id] = $product;
	}

	public function get_products() {
		return $this->products;
	}

	public function get_api_url( $path ) {
		return "{$this->api_url}/{$path}";
	}

	public function get_updates( $transient ) {
		if ( empty( $transient ) ) {
			return $transient;
		}
		
		if ( empty( $transient->checked ) ) {
			$transient->checked = array();
		}

		foreach( $this->products as $product ) {
			$update_info = $product->get_info();

			if ( ! $update_info ) {
				continue;
			}

			if ( version_compare( $product->version, $update_info->version, '<' ) ) {
				$transient->response[$product->plugin_slug] = $product->get_update( $update_info );
			}

			$transient->checked[$product->plugin_slug] = $product->version;
		}

		return $transient;
	}

	public function get_info( $false, $action, $args ) {
		if ( 'plugin_information' !== $action ) {
			return $false;
		}

		foreach( $this->products as $product ) {
			if ( $args->slug !== $product->id ) {
				continue;
			}

			$info = $product->get_info();

			if ( ! $info ) {
				continue;
			}

			return $info;
		}

		return $false;
	}

	public function http_request_args( $args, $url ) {
		foreach( $this->products as $product ) {
			if ( $product->get_download_link() === $url ) {
				$args['headers']['X-TTF-PRODUCT-KEY'] = get_option( $product->option, '' );
				break;
			}
		}

		return $args;
	}

	public function check_authorization() {
		global $pagenow;

		$is_single_update = (
			( 'update.php' === $pagenow )
			&& isset( $_GET['action'] )
			&& ( 'upgrade-plugin' === $_GET['action'] )
			&& isset( $_GET['plugin'] )
		);

		$is_multiple_update = (
			( 'update-core.php' === $pagenow )
			&& isset( $_GET['action'] )
			&& ( 'do-plugin-upgrade' === $_GET['action'] )
			&& isset( $_POST['checked'] )
		);

		$is_update = $is_single_update || $is_multiple_update;

		if ( ! $is_update ) {
			return;
		}

		$plugin = $is_single_update ? $_GET['plugin'] : $_POST['checked'];

		foreach( $this->products as $product ) {
			if ( $product->plugin_slug === $plugin && ! $product->is_authorized() ) {
				$authorize_url = add_query_arg( array(
					'page' => $product->page
				), admin_url( 'admin.php' ) );

				wp_safe_redirect( $authorize_url );
				exit();
			}
		}
	}

	public function upgrader_pre_download( $reply, $package, $upgrader ) {
		foreach( $this->products as $product ) {
			if ( $product->get_download_link() === $package && ! $product->is_authorized()  ) {
				$authorize_url = add_query_arg( array(
					'page' => $product->page
				), admin_url( 'admin.php' ) );

				$message = sprintf(
					__( '%s is not configured for remote updates.', 'ttf-updates' ),
					$product->name, $authorize_url, $product->name
				);

				return new WP_Error( 'auth', $message );
			}
		}

		return $reply;
	}

}

if ( ! function_exists( 'ttf_product_central_updater' ) ) :

function ttf_product_central_updater() {
	return TTF_Product_Central_Updater::instance();
}

endif;

ttf_product_central_updater();