/**
 * (c) Greg Priday, freely distributable under the terms of the GPL 2.0 license.
 */

function ob_loadMap($) {
    $('.ob-google-map-canvas').each(function () {
        var $$ = $(this);
        // We use the ob_geocoder
        var ob_geocoder = new google.maps.Geocoder();

        if( $$.data('display_by') && $$.data('display_by') != 'address' ) {
            var thim_map = {'location': {lat: parseFloat($$.data('lat')), lng: parseFloat($$.data('lng'))} };
        }else{
            var thim_map = {'address': $$.data('address')};
        }
        ob_geocoder.geocode( thim_map , function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                var zoom = Number($$.data('zoom'));
                if ( !zoom ) zoom = 14;
                var userMapTypeId = 'user_map_style';
                var mapOptions = {
                    zoom: zoom,
                    scrollwheel: Boolean( $$.data('scroll-zoom') ),
                    //   draggable: Boolean( $$.data('draggable') ),
                    center: results[0].geometry.location,
                    mapTypeControlOptions: {
                        mapTypeIds: [google.maps.MapTypeId.ROADMAP, userMapTypeId]
                    }
                };

                var map = new google.maps.Map($$.get(0), mapOptions);

                var userMapOptions = {
                    name: $$.data('map-name')
                };

                var userMapStyles = $$.data('map-styles');

                if ( userMapStyles ) {
                    var userMapType = new google.maps.StyledMapType(userMapStyles, userMapOptions);

                    map.mapTypes.set(userMapTypeId, userMapType);
                    map.setMapTypeId(userMapTypeId);
                }

                if ( Boolean( $$.data('marker-at-center' ) ) ) {

                    new google.maps.Marker({
                        position: results[0].geometry.location,
                        map: map,
                        //  draggable: Boolean( $$.data('markers-draggable') ),
                        icon: $$.data('marker-icon'),
                        title: ''
                    });
                }
                var markerPositions = $$.data('marker-positions');
                if ( markerPositions && markerPositions.length ) {
                    markerPositions.forEach(
                        function(mrkr) {
                            ob_geocoder.geocode( { 'address': mrkr.place }, function (res, status) {
                                if ( status == google.maps.GeocoderStatus.OK ) {
                                    new google.maps.Marker({
                                        position: res[0].geometry.location,
                                        map: map,
                                        // draggable: Boolean( $$.data('markers-draggable') ),
                                        icon: $$.data('marker-icon'),
                                        title: ''
                                    });
                                }
                            });
                        }
                    );
                }
                var directions = $$.data('directions');
                if ( directions ) {

                    if ( directions.waypoints && directions.waypoints.length ) {
                        directions.waypoints.map(
                            function (wypt) {
                                wypt.stopover = Boolean(wypt.stopover);
                            }
                        );
                    }

                    var directionsRenderer = new google.maps.DirectionsRenderer();
                    directionsRenderer.setMap(map);

                    var directionsService = new google.maps.DirectionsService();
                    directionsService.route({
                            origin: directions.origin,
                            destination: directions.destination,
                            travelMode: directions.travelMode.toUpperCase(),
                            avoidHighways: Boolean( directions.avoidHighways ),
                            avoidTolls: Boolean( directions.avoidTolls ),
                            waypoints: directions.waypoints,
                            optimizeWaypoints: Boolean( directions.optimizeWaypoints )

                        },
                        function(result, status) {
                            if (status == google.maps.DirectionsStatus.OK) {
                                directionsRenderer.setDirections(result);
                            }
                        });
                }
            }
            else if (status == google.maps.GeocoderStatus.ZERO_RESULTS) {
                $$.append('<div><p><strong>There were no results for the place you entered. Please try another.</strong></p></div>');
            }
        });
    });
}

function ob_loadApi($) {
    var apiKey = ( $('.ob-google-map-canvas').data('api-key') && $('.ob-google-map-canvas').data('api-key') != '' ) ? $('.ob-google-map-canvas').data('api-key') : 'AIzaSyCEv6YBbPEv4wCR-AkQ5dmQ4GXXGa_6vIc';

    var apiUrl = 'https://maps.googleapis.com/maps/api/js?v=3.exp&callback=initialize';
    if(apiKey) {
        apiUrl += '&key=' + apiKey;
    }
    var script = $('<script type="text/javascript" src="' + apiUrl + '">');
    $('body').append(script);
}

function initialize() {
    ob_loadMap(window.jQuery);
}

jQuery(function ($) {
    if (window.google) {
        ob_loadMap($);
    } else {
        ob_loadApi($);
    }
});