<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if(defined('ELEMENTOR_VERSION')):

include_once TURITOR_EDITOR . '/elementor/manager/controls.php';

class Turitor_Shortcode{

	/**
     * Holds the class object.
     * 
     * @since 1.0
     *
     */
    public static $_instance;
    

    /**
     * Localize data array
     *
     * @var array
     */
    public $localize_data = array();

	/**
     * Load Construct
     * 
     * @since 1.0
     */

	public function __construct(){

		add_action('elementor/init', array($this, 'TURITOR_elementor_init'));
        add_action('elementor/controls/controls_registered', array( $this, 'turitor_icon_pack' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'control_image_choose' ), 13 );
        add_action('elementor/controls/controls_registered', array( $this, 'TURITOR_ajax_select2' ), 13 );
        add_action('elementor/widgets/widgets_registered', array($this, 'TURITOR_shortcode_elements'));
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_enqueue_scripts' ) );

        // elemntor icon load
        $this -> Turitor_elementor_icon_pack();

        
	}


    /**
     * Enqueue Scripts
     *
     * @return void  
     */ 
    
     public function enqueue_scripts() {
         wp_enqueue_script( 'turitor-main-elementor', TURITOR_JS  . '/elementor.js',array( 'jquery', 'elementor-frontend' ), TURITOR_VERSION, true );
    }

    /**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {

        wp_enqueue_style( 'turitor-icon-elementor', TURITOR_CSS.'/iconfont.css',null, TURITOR_VERSION );

    }

    /**
     * Preview Enqueue Scripts
     *
     * @return void
     */

    public function preview_enqueue_scripts() {}
	/**
     * Elementor Initialization
     *
     * @since 1.0
     *
     */

    public function TURITOR_elementor_init(){
    
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'turitor-elements',
            [
                'title' =>esc_html__( 'Turitor', 'turitor' ),
                'icon' => 'fa fa-plug',
            ],
            1
        );
    }

    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */ 

    public function TURITOR_icon_pack( $controls_manager ) {

        require_once TURITOR_EDITOR_ELEMENTOR. '/controls/icon.php';

        $controls = array(
            $controls_manager::ICON => 'Turitor_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }

    
    // elementor icon fonts loaded
    public function Turitor_elementor_icon_pack(  ) {

		$this->__generate_font();
		
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this, '__add_font']);
		
    }
    
    public function __add_font( $font){
        $font_new['icon-electionify'] = [
            'name' => 'icon-turitor',
            'label' => esc_html__( 'turitor Icon', 'turitor' ),
            'url' => TURITOR_CSS . '/iconfont.css',
            'enqueue' => [ TURITOR_CSS . '/iconfont.css' ],
            'prefix' => 'tsicon-',
            'displayPrefix' => 'tsicon',
            'labelIcon' => 'tsicon tsicon-hand',
            'ver' => '5.9.0',
            'fetchJson' => TURITOR_JS . '/iconfont.js',
            'native' => true,
        ];
        return  array_merge($font, $font_new);
    }


    public function __generate_font(){
        global $wp_filesystem;

        require_once ( ABSPATH . '/wp-admin/includes/file.php' );
        WP_Filesystem();
        $css_file =  TURITOR_CSS_DIR . '/iconfont.css';
    
        if ( $wp_filesystem->exists( $css_file ) ) {
            $css_source = $wp_filesystem->get_contents( $css_file );
        } // End If Statement
        
        preg_match_all( "/\.(tsicon-.*?):\w*?\s*?{/", $css_source, $matches, PREG_SET_ORDER, 0 );
        $iconList = [];
        
        foreach ( $matches as $match ) {
            $new_icons[$match[1] ] = str_replace('tsicon-', '', $match[1]);
            $iconList[] = str_replace('tsicon-', '', $match[1]);
        }

        $icons = new \stdClass();
        $icons->icons = $iconList;
        $icon_data = json_encode($icons);
        
        $file = TURITOR_THEME_DIR . '/assets/js/iconfont.js';
        
            global $wp_filesystem;
            require_once ( ABSPATH . '/wp-admin/includes/file.php' );
            WP_Filesystem();
            if ( $wp_filesystem->exists( $file ) ) {
                $content =  $wp_filesystem->put_contents( $file, $icon_data) ;
            } 
        
    }




    // registering ajax select 2 control
    public function TURITOR_ajax_select2( $controls_manager ) {
        require_once TURITOR_EDITOR_ELEMENTOR. '/controls/select2.php';
        $controls_manager->register_control( 'ajaxselect2', new \Control_Ajax_Select2() );
    }
    
    // registering image choose
    public function control_image_choose( $controls_manager ) {
        require_once TURITOR_EDITOR_ELEMENTOR. '/controls/choose.php';
        $controls_manager->register_control( 'imagechoose', new \Control_Image_Choose() );
    }

    public function TURITOR_shortcode_elements($widgets_manager){
        
            //learnpress 
            if(defined('LP_COURSE_CPT')){
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/course.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Course_Widget());
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/course-category.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Course_category_Widget());
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/course-loadmore.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Course_LoadMore_Widget());
                
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/course-search.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Course_Search_Widget());
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/instructor.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Instructor_Widget());
               
            }
            //end learnpress

            //   Learndash course
            if ( class_exists( 'SFWD_LMS' ) ) {
                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/learndash-course.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Learndash_Course_Widget());

                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/ld-course-category.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_Ld_Course_cat_Widget());

                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/learndash-login.php';
                $widgets_manager->register_widget_type(new Elementor\learndash_User_Login_Widget());    

                
            }
            // Learndash course end

            //   tutor course
            if ( function_exists('tutor') ) {

                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/tutor-course-category.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_tutor_Course_cat_Widget());

                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/instructor-tutor.php';
                $widgets_manager->register_widget_type(new Elementor\Tutor_Instructor_Widget());

                require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/tutor-course.php';
                $widgets_manager->register_widget_type(new Elementor\Turitor_tutor_Course_Widget()); 

           
            }
            // tutor course end


            // cart btn widget
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/cart-btn.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Cartbtn_Widget());
         

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/main-slider.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Main_Slider_Widget());
          
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/event.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Event_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/news.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_news_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/title.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Title_Widget());


            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/testimonial.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Testimonial_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/list.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_list_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/masonary-gallery.php';
            $widgets_manager->register_widget_type(new Elementor\turitor_masonary_gallery_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/logo.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Site_Logo_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/user-login.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_User_Login_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/feature-standard.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Feature_Standard_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/feature-classic.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_feature_classic_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/turitor-tab.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Tab());
          
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/service-slider.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Service_Slider_Widget());
           
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/campus-slider.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Campus_Slider_Widget()); 

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/back-to-top.php';
            $widgets_manager->register_widget_type(new Elementor\turitor_BackToTop_Widget());   

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/team.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Team_Widget());  

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/topics.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Topics_Widget());      

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/popup.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Popup_Widget());         
            
            // BuddyPress 
        if (class_exists('BuddyPress')) {

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/bp-member.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Buddypress_Member_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/bp-group.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Buddypress_Group_Widget());
            
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/bp-topic.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Buddypress_Topic_Widget());
            
            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/bp-user-notification.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Buddypress_notification_Widget());

            require_once TURITOR_EDITOR_ELEMENTOR.'/widgets/bp-unread-message.php';
            $widgets_manager->register_widget_type(new Elementor\Turitor_Buddypress_Unreadmessage_Widget());
        }            
    }
    
	public static function Turitor_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Turitor_Shortcode();
        }
        return self::$_instance;
    }

}
$TURITOR_Shortcode = Turitor_Shortcode::Turitor_get_instance();

endif;