<?php
   namespace Elementor;
   
   if ( ! defined( 'ABSPATH' ) ) exit;

   class Turitor_Buddypress_Topic_Widget extends Widget_Base {
   
   
      public $base;
   
      public function get_name() {
         return 'buddypress-topic';
      }
   
      public function get_title() {
         return esc_html__( 'Buddypress Topic', 'turitor' );
      }
   
      public function get_icon() { 
         return 'far fa-list-alt';
      }
   
      public function get_categories() {
         return [ 'turitor-elements' ];
      }
   
      protected function _register_controls() {
         $this->start_controls_section(
            'section_tab', [
               'label' => esc_html__( 'Latest Topic', 'turitor' ),
            ]
         );
      
         $this->add_control(
         'topic_count',
            [
               'label'         => esc_html__( 'Topic count', 'turitor' ),
               'type'          => Controls_Manager::NUMBER,
               'default'       => '4',
            ]
         );
   
         $this->add_control(
            'topic_style',
            [
               'label'   => esc_html__( 'Topic Style', 'turitor' ),
               'type'    => Controls_Manager::SELECT,
               'default' => 'style1',
               'options' => [
                  'style1'  => esc_html__( 'Style 1 ', 'turitor' ),
               ],
            ]
         );
      
      $this->add_control(
         'post_col',
         [
            'label'   => esc_html__( 'Post Column', 'turitor' ),
            'type'    => Controls_Manager::SELECT,
            'default' => '4',
            'options' => [
               '3'  => esc_html__( '4 Column ', 'turitor' ),
               '4'  => esc_html__( '3 Column', 'turitor' ),
               '6'  => esc_html__( '2 Column', 'turitor' ),
            ],
         ]
      );
   
      
      $this->end_controls_section();
      
		$this->start_controls_section(
			'buddypress_topic_style',
			[
				'label'	 => esc_html__('Topic Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

      $this->add_responsive_control(
			'buddypress_topic_padding',
			[
				'label' => esc_html__('Topic Item Padding', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #buddypress .activity-list > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

      $this->add_responsive_control(
			'buddypress_topic_margin',
			[
				'label' => esc_html__('Topic Item Margin', 'turitor'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} #buddypress .activity-list > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
      $this->end_controls_section();
   
   } 
   
    protected function render() {
      
      $settings        = $this->get_settings();

      $topic_style = $settings['topic_style'];
      $topic_count = $settings['topic_count'];

      include (locate_template("components/editor/elementor/widgets/style/buddypress/topics/{$topic_style}.php", false, false ));  
   
    }
}