<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class Turitor_Course_LoadMore_Widget extends Widget_Base
{


  public $base;

  public function get_name()
  {
    return 'turitor-course-loadmore';
  }

  public function get_title()
  {
    return esc_html__('Course Load More', 'turitor');
  }

  public function get_icon()
  {
    return 'eicon-person';
  }

  public function get_categories()
  {
    return ['turitor-elements'];
  }



  protected function _register_controls()
  {
    $this->start_controls_section(
      'content',
      [
        'label' => esc_html__('Courses', 'turitor')
      ]
    );


    $this->add_control(
      'layout',
      [
        'label'   => esc_html__('Layout', 'turitor'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'grid-1'         => esc_html__('Grid 1', 'turitor'),
        ],
        'default' => 'grid-1'
      ]
    );

    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order By', 'turitor'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'popular'  => esc_html__('Popular', 'turitor'),
          'latest'   => esc_html__('Latest', 'turitor'),
        ],
        'default' => 'latest',

      ]
    );




    $this->add_control(
      'limit',
      [
        'label'   => esc_html__('Limit Number Courses', 'turitor'),
        'type'    => Controls_Manager::NUMBER,
        'default' => 8,
        'min'     => 1,
        'step'    => 1,

      ]
    );

    $this->add_control(
      'cat_id',
      [
        'label'     => esc_html__('Select Category', 'turitor'),
        'type'      => Controls_Manager::SELECT2,
        'options'   => $this->course_category(),
        'multiple'    => true,
        'default'     => 'all',

      ]
    );

    $this->add_control(
      'featured',
      [
        'label'        => esc_html__('Display Featured Courses?', 'turitor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'turitor'),
        'label_off'    => esc_html__('No', 'turitor'),
        'return_value' => 'yes',
        'default'      => '',

      ]
    );


    $this->end_controls_section();




    $this->start_controls_section(
      'title_style',
      [
        'label'   => esc_html__('Title', 'turitor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label'     => esc_html__('Title color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course .ts-course-el-title a' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'title_hover_color',
      [
        'label'     => esc_html__('Title hover color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course:hover .ts-course-el-title a' => 'color: {{VALUE}};',
        ],
      ]
    );


    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'selector'   => '{{WRAPPER}} .single-course .ts-course-el-title',
      ]
    );

    $this->add_responsive_control(
      'title_margin',
      [
        'label' => esc_html__('Tilte margin', 'turitor'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .single-course .ts-course-el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'category_meta_style',
      [
        'label'   => esc_html__('Meta Style', 'turitor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'meta_color',
      [
        'label'     => esc_html__('color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course .course-category a' => 'color: {{VALUE}};',
          '{{WRAPPER}} .single-course .course-enrole-list li' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'meta_hover_color',
      [
        'label'     => esc_html__('Meta  color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course:hover .course-category a' => 'color: {{VALUE}};',
          '{{WRAPPER}} .single-course:hover .course-enrole-list li' => 'color: {{VALUE}};',
        ],
      ]
    );


    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'meta_title_typography',
        'selector'   => '{{WRAPPER}} .single-course .course-category a, {{WRAPPER}} .single-course .course-enrole-list li',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'instructor_style',
      [
        'label'   => esc_html__('Instructor Style', 'turitor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'instructor_hover_color',
      [
        'label'     => esc_html__('Instructor color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course .instructor a' => 'color: {{VALUE}};',
        ],
      ]
    );


    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'instructor_title_typography',
        'selector'   => '{{WRAPPER}} .single-course .instructor a',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'price_style',
      [
        'label'   => esc_html__('Price Style', 'turitor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'price_bg_color',
      [
        'label'     => esc_html__('Background color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course .course-footer .course-price-item span' => 'background-color: {{VALUE}};',
          '{{WRAPPER}} .course-single-wrap .single-course .course-price-item span' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'price_color',
      [
        'label'     => esc_html__('Color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course .course-footer .course-price-item span' => 'color: {{VALUE}};',
          '{{WRAPPER}} .course-single-wrap .single-course .course-price-item span' => 'color: {{VALUE}};',
        ],
      ]
    );


    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'price_title_typography',
        'selector'   => '{{WRAPPER}} .single-course .course-price-item span',
      ]
    );
    $this->end_controls_section();



    $this->start_controls_section(
      'advance_style',
      [
        'label'   => esc_html__('Advance Style', 'turitor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );



    $this->add_control(
      'box_bg_color',
      [
        'label'     => esc_html__('Box background color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'box_bg_color_hover',
      [
        'label'     => esc_html__('Box background hover color', 'turitor'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .single-course:hover' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'course_price_shadow',
        'label' => esc_html__('Course price Shadow', 'turitor'),
        'selector' => '{{WRAPPER}} .single-course .course-footer .course-price-item .course-price',
      ]
    );

    $this->add_responsive_control(
      'content_margin',
      [
        'label' => esc_html__('Box margin', 'turitor'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'allowed_dimensions' => ['top', 'bottom'],
        'selectors' => [
          '{{WRAPPER}} .single-course' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'content_padding',
      [
        'label' => esc_html__('Box padding', 'turitor'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .single-course' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'box_border_radius',
      [
        'label' => esc_html__('Box border radius', 'turitor'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .single-course' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .course-single-wrap .course-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .course-single-wrap .course-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('boxed_border_styled');

    $this->start_controls_tab(
      'boxed_border_style_normal',
      [
        'label' => esc_html__('Normal', 'turitor'),
      ]
    );

    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name' => 'borders_noromal',
        'label' => esc_html__('Box Border', 'turitor'),
        'selector' => '{{WRAPPER}} .single-course',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'feature_box_shadow',
        'label' => esc_html__('Box Shadow', 'turitor'),
        'selector' => '{{WRAPPER}} .single-course',
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'boxed_border_style_hover',
      [
        'label' => esc_html__('Hover', 'turitor'),
      ]
    );

    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name' => 'hover_border',
        'label' => esc_html__('Box Border', 'turitor'),
        'selector' => '{{WRAPPER}} .single-course:hover',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'feature_box_hov_shadow',
        'label' => esc_html__('Box hover Shadow', 'turitor'),
        'selector' => '{{WRAPPER}} .single-course:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->end_controls_section();
  }
  protected function render()
  {

    $settings   = $this->get_settings();
    $cat_id = $settings['cat_id'] ? $settings['cat_id'] : array();
    $featured   = !empty($settings['featured']) ? true : false;

    $args = array(
      'post_type'           => 'lp_course',
      'posts_per_page' => $settings['limit'],
      'order' => $settings['order'],

    );

    if (count($cat_id)) {

      $args['tax_query'] = array(
        array(
          'taxonomy' => 'course_category',
          'field'    => 'term_id',
          'terms'    => $cat_id
        ),
      );
    }

    if ($featured) {
      $args['meta_query'] = array(
        array(
          'key' => '_lp_featured',
          'value' =>  'yes',
        )
      );
    }

    $the_query = new \WP_Query($args);

    if ($the_query->have_posts()) :

      if (defined('LP_COURSE_CPT')) {
?>
        <div class="course-single-wrap row">
          <?php include(locate_template("components/editor/elementor/widgets/style/courses/grid-loadmore.php", false, false)); ?>
        </div>
    <?php
      }
    endif;
    ?>
    <div class="loadmore btn btn-primary" data-cat_id="<?php echo json_encode($settings['cat_id']); ?>" data-order="<?php echo  $settings['order']; ?>" data-posts_per_page="<?php echo $settings['limit']; ?>" data-paged="<?php echo isset($paged) ? $paged : 2; ?>"><?php echo esc_html('Load More...', 'turitor'); ?></div>

<?php
  }

  // Get list courses category
  public function course_category()
  {
    if (!defined('LP_COURSE_CPT')) {
      return [];
    }
    $tax_terms = get_terms('course_category', array('hide_empty' => false));
    $category_list = [];

    foreach ($tax_terms as $term_single) {
      $category_list[$term_single->term_id] = [$term_single->name];
    }

    return $category_list;
  }
}
