<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Course_Search_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-course-search';
    }

    public function get_title() {
        return esc_html__( 'Course Search Filter', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-search';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Search', 'turitor'),
            ]
        );

        $this->add_control(
			'placeholder_text', [
				'label'		 => esc_html__( 'Placeholder Text', 'turitor' ),
				'type'		 => Controls_Manager::TEXT,
            'default'    => esc_html__('What do you want to learn ?', 'turitor'),
			]
      );

      $this->add_control(
         'turitor_search_icons',
         [
             'label' => esc_html__('Select Icon', 'turitor'),
             'default' => [
                 'value' => 'tsicon tsicon-search',
             ],
             'label_block' => true,
             'type' => Controls_Manager::ICONS,

         ]
     );

		$this->end_controls_section();

		$this->start_controls_section(
			'search_field', [
				'label'	 => esc_html__( 'Search Field', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'title_typography',
			'selector'	 => '{{WRAPPER}} .search-course-input',
			]
			);

      $this->add_control(
			'field_color', [
				'label'		 => esc_html__( 'Text color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .search-course-input' => 'color: {{VALUE}};',
				],
			]
      );
   
      $this->add_control(
			'field_bg_color', [
				'label'		 => esc_html__( 'Field BG color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .search-course-input' => 'background: {{VALUE}};',
				],
			]
      );
      $this->add_control(
			'placeholder_text_color', [
				'label'		 => esc_html__( 'Placeholder Text color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .search-course-input::placeholder' => 'color: {{VALUE}};',
				],
			]
      );
      $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .search-course-input',
			]
      );
      
      $this->add_responsive_control(
         'field_border_radius',
         [
            'label' => esc_html__( 'Border Radius', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
               '{{WRAPPER}} .search-course-input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
         );

         $this->add_control(
            'field_height',
            [
               'label' => esc_html__( 'Height', 'turitor' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 1000,
                     'step' => 5,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'default' => [
                  'unit' => 'px',
                  'size' => 50,
               ],
               'selectors' => [
                  '{{WRAPPER}} .search-course-input' => 'height: {{SIZE}}{{UNIT}};',
               ],
            ]
         );

         $this->add_control(
            'filed_padding',
            [
               'label' => esc_html__( 'padding', 'turitor' ),
               'type' => Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em' ],
               'allowed_dimensions' => [ 'top','right','bottom', 'left' ],
               'selectors' => [
                  '{{WRAPPER}} .search-course-input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
            ]
         );
   


      $this->end_controls_section();  

		$this->start_controls_section(
			'button_field', [
				'label'	 => esc_html__( 'Button Field', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'button_typography',
			'selector'	 => '{{WRAPPER}} .turitor-search-course-form .search-course-button',
			]
			);

      $this->add_control(
			'btn_color', [
				'label'		 => esc_html__( 'Button color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'color: {{VALUE}};',
				],
			]
      );
      $this->add_control(
			'button_bg_color', [
				'label'		 => esc_html__( 'Button BG color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'background: {{VALUE}};',
				],
			]
      );

      $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'label' => esc_html__( 'Border', 'turitor' ),
				'selector' => '{{WRAPPER}} .turitor-search-course-form .search-course-button',
			]
      );
      
      $this->add_responsive_control(
         'button_border_radius',
         [
            'label' => esc_html__( 'Border Radius', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
               '{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
         );

         $this->add_control(
            'button_width',
            [
               'label' => esc_html__( 'width', 'turitor' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 1000,
                     'step' => 5,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'default' => [
                  'unit' => 'px',
                  'size' => 20,
               ],
               'selectors' => [
                  '{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'width: {{SIZE}}{{UNIT}};',
               ],
            ]
         );
         $this->add_control(
            'button_height',
            [
               'label' => esc_html__( 'Height', 'turitor' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 1000,
                     'step' => 5,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'default' => [
                  'unit' => 'px',
                  'size' => 50,
               ],
               'selectors' => [
                  '{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'height: {{SIZE}}{{UNIT}} !important;',
               ],
            ]
         );

         $this->add_responsive_control(
            'button_margin',
            [
               'label' => esc_html__( 'Margin', 'turitor' ),
               'type' => Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em' ],
               'allowed_dimensions' => [ 'top','right','bottom', 'left' ],
               'selectors' => [
                  '{{WRAPPER}} .turitor-search-course-form .search-course-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
            ]
         );
   

      $this->end_controls_section();  

      
       

   } 

   protected function render( ) { 
      $settings       = $this->get_settings();
      $placeholder_text = $settings['placeholder_text'];
   
     
   ?>

      <div class="turitor-course-search header-course-search">
       <form method="get" name="search-course" class="turitor-search-course-form"
               action="<?php echo learn_press_get_page_link( 'courses' ); ?>">

            <input type="text" name="s" class="search-course-input"
                  placeholder="<?php echo esc_html( $placeholder_text ); ?>"/>
            <input type="hidden" name="ref" value="course"/>

            <button class="lp-button button search-course-button"><?php Icons_Manager::render_icon( $settings['turitor_search_icons'], [ 'aria-hidden' => 'true' ] ); ?></button>
			</form>
      </div>
    
    <?php  
    }
    protected function _content_template() { }
}