<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_feature_classic_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-feature-classic';
    }

    public function get_title() {
        return esc_html__( 'Turitor Feature classic', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('list settings', 'turitor'),
            ]
        );

        $this->add_control(
			'title', [
				'label'			=> esc_html__( 'Title', 'turitor' ),
				'type'			=> Controls_Manager::TEXT,
				'label_block'	=> true,
				'placeholder'	=> esc_html__( 'Best quality', 'turitor' ),
				'default'	    => esc_html__( 'Best quality', 'turitor' ),
			]
			
		);
     
      $this->add_control(
			'desc', [
			'label'			=> esc_html__( 'Content', 'turitor' ),
			'type'			=> Controls_Manager::TEXTAREA,
			'label_block'	=> true,
			'placeholder'	=> esc_html__( 'Which i enjoy with my whole heart', 'turitor' ),
         	'default'      => esc_html__( 'Which i enjoy with my whole heart.', 'turitor' ),
           
			]
      );

      $this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'turitor' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
      );
      $this->add_control(
			'shape_image',
			[
				'label' => esc_html__( 'Choose Shape Image', 'turitor' ),
            'type' => Controls_Manager::MEDIA,
            'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
      );
      
      $this->add_responsive_control(
			'title_align', [
				'label'			 => esc_html__( 'Alignment', 'turitor' ),
				'type'			 => Controls_Manager::CHOOSE,
				'options'		 => [

					'left'		 => [
						'title'	 => esc_html__( 'Left', 'turitor' ),
						'icon'	 => 'fa fa-align-left',
					],
					'center'	 => [
						'title'	 => esc_html__( 'Center', 'turitor' ),
						'icon'	 => 'fa fa-align-center',
					],
					'right'		 => [
						'title'	 => esc_html__( 'Right', 'turitor' ),
						'icon'	 => 'fa fa-align-right',
					],
					'justify'	 => [
						'title'	 => esc_html__( 'Justified', 'turitor' ),
						'icon'	 => 'fa fa-align-justify',
					],
				],
				'default'		 => 'left',
                'selectors' => [
                    '{{WRAPPER}} .feature-classic' => 'text-align: {{VALUE}};',
                    
				],
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style', [
				'label'	 => esc_html__( 'Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_control(
			'title_color', [
				'label'		 => esc_html__( 'Title color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .feature-classic h3' => 'color: {{VALUE}};',
				],
			]
      );

       
      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'title_typography',
			'selector'	 => '{{WRAPPER}} .feature-classic h3',
			]
			);
			
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Tilte margin', 'turitor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .feature-classic h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);

      $this->end_controls_section();  

		$this->start_controls_section(
			'section_content_style', [
				'label'	 => esc_html__( 'Content', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_control(
			'content_color', [
				'label'		 => esc_html__( 'Content color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .feature-classic p' => 'color: {{VALUE}};',
				],
			]
      );

       
      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'content_typography',
			'selector'	 => '{{WRAPPER}} .feature-classic p',
			]
			);
			
    $this->add_responsive_control(
        'content_margin',
        [
            'label' => esc_html__( 'Content margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .feature-classic p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
        );

      $this->end_controls_section();  

   } 

   protected function render( ) { 
      $settings       = $this->get_settings();

   	$title       =  $settings["title"];
      $desc        =  $settings["desc"];
      $shape_image        =  $settings["shape_image"];
      if(isset($shape_image) && $shape_image['url'] !=''){
         $shape_image =  $shape_image["url"];
      }
	
      		
     
   ?>
		<div class="feature-classic">
         <div class="feature-img">
            <img src="<?php echo esc_attr($settings['image']['url']) ?>" alt="<?php echo esc_attr($title); ?>">
         </div>
         <div class="feature-content" style="background-image: url(<?php echo esc_url($shape_image); ?>)">
            <h3 class="ts-title"><?php echo turitor_kses($title); ?></h3>
            <p>
               <?php echo turitor_kses($desc); ?>
            </p>
         </div>
		</div>
 
    
    <?php  
    }
    protected function _content_template() { }
}