<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_list_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-list';
    }

    public function get_title() {
        return esc_html__( 'Turitor List', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('list settings', 'turitor'),
            ]
        );

          
         $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'list_title', [
               'label'        => esc_html__('List title', 'turitor'),
               'type'        => Controls_Manager::TEXT,
               'default'     => esc_html__('List content #1', 'turitor'),
               'label_block'  => true,
            ]
         );
         $repeater->add_control(
            'list_content', [
               'label'       => esc_html__('List Content', 'turitor'),
               'type'         => Controls_Manager::TEXTAREA,
               'default'     => esc_html__('List content #1', 'turitor'),
               'label_block' => true,
            ]
         );

         $this->add_control(
            'list_item',
            [
               'label' => esc_html__('List', 'turitor'),
               'type' => \Elementor\Controls_Manager::REPEATER,
               'fields' => $repeater->get_controls(),
               'default' => [
                  [
                     'list_title' => esc_html__('List content #1', 'turitor'),
                  ],
               ],
               'title_field' => '{{{ list_title }}}',
            ]
         );
        
         $this->add_responsive_control(
            'title_align', [
               'label'			 => esc_html__( 'Alignment', 'turitor' ),
               'type'			 => Controls_Manager::CHOOSE,
               'options'		 => [

                  'left'		 => [
                     'title'	 => esc_html__( 'Left', 'turitor' ),
                     'icon'	 => 'fa fa-align-left',
                  ],
                  'center'	 => [
                     'title'	 => esc_html__( 'Center', 'turitor' ),
                     'icon'	 => 'fa fa-align-center',
                  ],
                  'right'		 => [
                     'title'	 => esc_html__( 'Right', 'turitor' ),
                     'icon'	 => 'fa fa-align-right',
                  ],
                  'justify'	 => [
                     'title'	 => esc_html__( 'Justified', 'turitor' ),
                     'icon'	 => 'fa fa-align-justify',
                  ],
               ],
               'default'		 => 'left',
                  'selectors' => [
                     '{{WRAPPER}} .turitor-list' => 'text-align: {{VALUE}};',
                     
               ],
            ]
         );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style', [
				'label'	 => esc_html__( 'Title', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_control(
			'title_color', [
				'label'		 => esc_html__( 'Title color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-list li h3' => 'color: {{VALUE}};',
				],
			]
      );

       
      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'title_typography',
			'selector'	 => '{{WRAPPER}} .turitor-list li h3',
			]
			);
			
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Tilte margin', 'turitor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors' => [
						'{{WRAPPER}} .turitor-list li h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);

      $this->end_controls_section();  

		$this->start_controls_section(
			'section_content_style', [
				'label'	 => esc_html__( 'Content', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
      );

      $this->add_control(
			'content_color', [
				'label'		 => esc_html__( 'Content color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-list li p' => 'color: {{VALUE}};',
				],
			]
      );

       
      $this->add_group_control(
			Group_Control_Typography::get_type(), [
			'name'		 => 'content_typography',
			'selector'	 => '{{WRAPPER}} .turitor-list li p',
			]
			);
			
    $this->add_responsive_control(
        'content_margin',
        [
            'label' => esc_html__( 'Content margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .turitor-list li p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
        );

      $this->end_controls_section();  

      $this->start_controls_section(
        'section_advance_style', [
            'label'	 => esc_html__( 'Advance', 'turitor' ),
                    'tab'	 => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
			'border_color', [
				'label'		 => esc_html__( 'Border color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-list li:before' => 'background: {{VALUE}};',
				],
			]
      );
        $this->add_control(
			'dot_color', [
				'label'		 => esc_html__( 'Dot color', 'turitor' ),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .turitor-list li:after' => 'background: {{VALUE}};',
				],
			]
      );

      $this->end_controls_section();  

       

   } 

   protected function render( ) { 
      $settings       = $this->get_settings();
      $list_item    = $settings['list_item']; 
   
     
   ?>

      <ul class="turitor-list">
         <?php foreach( $list_item as $list): ?>
         <li>
            <?php if(isset($list['list_title']) && $list['list_title'] !=''): ?>
               <h3><?php echo esc_html($list['list_title']); ?></h3>
            <?php endif; ?>

            <?php if(isset($list['list_content']) && $list['list_content'] !=''): ?>
               <p><?php echo esc_html($list['list_content']); ?></p>
            <?php endif; ?>

         </li>
         <?php endforeach; ?>
      </ul>
    
    <?php  
    }
    protected function _content_template() { }
}