<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Turitor_Popup_Widget extends Widget_Base
{


    public $base;

    public function get_name()
    {
        return 'turitor-popup';
    }

    public function get_title()
    {

        return esc_html__('Turitor Popup', 'turitor');
    }

    public function get_icon()
    {
        return 'fas fa-air-freshener';
    }

    public function get_categories()
    {
        return ['turitor-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Popup settings', 'turitor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => __('Button Icon', 'turitor'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
					'value' => 'fas fa-envelope',
                    'library' => 'solid',
				],
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label'         => esc_html__('Button Text', 'turitor'),
                'type'          => Controls_Manager::TEXT,
                'default' => esc_html__('Get a quote', 'turitor'),
            ]
        );
        $this->add_control(
            'popup_shorcode',
            [
                'label'         => esc_html__('Shortcode For Popup', 'turitor'),
                'type'          => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder'   => esc_html__('[enter your shortcode]', 'turitor'),
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => __('Button Alignment', 'turitor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'turitor'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'turitor'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'turitor'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors'     => [
                    '{{WRAPPER}} .turitor-popup-btn'  => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'btn_style',
            [
                'label'    => esc_html__('Button Style', 'turitor'),
                'tab'      => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typograpy',
                'label' => esc_html__('Typography', 'turitor'),
                
                'selector' => '{{WRAPPER}} .btn',
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label'     => esc_html__('Button  Color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'btn_hover_color',
            [
                'label'     => esc_html__('Button Hover Color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label'     => esc_html__('Button BG Color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'background-color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'btn_bg_hover_color',
            [
                'label'     => esc_html__('Button BG Hover Color', 'turitor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'background-color: {{VALUE}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('Button Padding', 'turitor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .btn ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_radius',
            [
                'label' => esc_html__('Button Border Radius', 'turitor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .btn ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings();

?>

        <div class="turitor-popup-btn">
            <a href="#popup<?php echo esc_attr($this->get_id()); ?>" class="turitor-popup btn btn-primary" data-effect="turitorbounceInDown">
                <?php \Elementor\Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); ?>
                <?php echo esc_html($settings['btn_text']); ?>
            </a>
        </div>
        <div id="popup<?php echo esc_attr($this->get_id()); ?>" class="container mfp-hide turitor-shortcode-popup turitor_animated turitorbounceInDown">
            <div class="turitor-popup-wrap">
                <?php echo do_shortcode($settings['popup_shorcode']); ?>
            </div>
        </div>

<?php
    }
    protected function _content_template()
    {
    }
}
