<?php
$mytextdomain = wp_get_theme()->get( 'TextDomain' );
    global $wp_query;
    $cat_id = $settings['cat_id'];

    $args = array(
        'post_type' => tutor()->course_post_type,
        'post_status' => 'publish',
        'posts_per_page' => $post_limit,
    );

    if ( count($cat_id) ) {

		$args['tax_query'] = array(
			array(
				'taxonomy' => 'course-category',
				'field'    => 'term_id',
				'terms'    => $cat_id
			),
		);
	
    }

   
    $q = new WP_Query($args);
    ?>

    <div class="tutor-courses-wrap tutor-course-style3 row">
        <?php
        if ($q->have_posts()) {
                while ($q->have_posts()) {
                    $q->the_post();
                    $idd = get_the_ID();
                    global $authordata;
                    $profile_url = tutor_utils()->profile_url($authordata->ID);
                 
                    $course_categories = get_tutor_course_categories();
                    $cat_color ='';

                    if(is_array($course_categories) && count($course_categories)){
                        foreach ($course_categories as $course_category){
                            $cat_color = turitor_term_meta_option($course_category->term_id, 'course-category','tutor_course_cat_color');
                        }
                     } 

                    ?>
                    <div class="col-lg-<?php echo $column; ?> col-sm-6 mb-30">
                        <div class="single-course-item course-grid-style2" style="--course-color: <?php echo esc_attr($cat_color);?>">
                            <div class="single-course">
                                    <div class="course-thumb">
                                        <?php tutor_course_loop_thumbnail();?>
                                    </div>
                                    <div class="course-title-area">
                                        <div class="course-category normal">
                                            <?php
                                            $course_categories = get_tutor_course_categories();
                                            if(is_array($course_categories) && count($course_categories)){
                                                ?>
                                                <?php
                                                    foreach ($course_categories as $course_category){
                                                        $category_name = $course_category->name;
                                                        $category_link = get_term_link($course_category->term_id);
                                                        echo "<a href='$category_link' style='background-color:  $cat_color;'>$category_name</a>";
                                                    }
                                                ?>
                                                
                                            <?php } ?>
                                        </div><!-- end category --> 
                                        <h3 class="ts-course-el-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo get_the_title(); ?>
                                            </a>
                                        </h3><!-- end title --> 

                                    </div> <!-- end title area -->
                                    <div class="course-footer style2">
                                        <div class="xs-ratting-content">
                                            <?php $course_rating = tutor_utils()->get_course_rating();?>
                                            <div class="tutor-loop-rating-wrap">
                                                <?php tutor_utils()->star_rating_generator($course_rating->rating_avg);?>
                                            </div>
                                        </div><!-- ratting end --> 
                                    <div class="course-price-item">
                                        <div class="tutor-course-loop-price">
                                            <?php
                                            $course_id = get_the_ID();
                                            $price_html = '<span class="amount">'.esc_html__('Free', 'tutor').'</span>';
                                            if (tutor_utils()->is_course_purchasable()) {
                                                $product_id = tutor_utils()->get_course_product_id($course_id);
                                                $product    = wc_get_product( $product_id );
                                                if ( $product ) {
                                                    $price_html = '<div class="turitor-course-pricess"> '.$product->get_price_html() . '</div> ';
                                                }
                                            }
                                                echo $price_html;
                                            ?>
                                            </div>
                                        </div><!-- price item --> 
                                    </div><!-- end course-footer -->
                                    <div class="single-course hover">
                                        <div class="course-category">
                                            <?php
                                            $course_categories = get_tutor_course_categories();

                                            if(is_array($course_categories) && count($course_categories)){
                                                ?>
                                                    <?php
                                                            foreach ($course_categories as $course_category){
                                                                $category_name = $course_category->name;
                                                                $category_link = get_term_link($course_category->term_id);
                                                                echo "<a href='$category_link'>$category_name</a>";
                                                            }
                                                    ?>
                                                
                                            <?php } ?>
                                        </div><!-- end category --> 

                                        <h3 class="ts-course-el-title">
                                            <a href="<?php the_permalink();?>">
                                                <?php echo get_the_title(); ?>
                                            </a>
                                        </h3><!-- end title --> 
                                        <div class="enrol-list-area">
                                            <div class="instructor">
                                                <a href="<?php echo esc_url($profile_url); ?>" class="tutor-course-author"><?php the_author();?></a>
                                            </div>
                                        </div><!-- end author -->
                                        <div class="excerpt-content">
                                            <p>
                                                <?php echo turitor_excerpt(10, ''); ?>
                                            </p>
                                        </div><!-- excerpt -->
                                    </div><!-- course hover -->
                            </div>
                        </div>
                    </div>
                <?php }
            } else {
                ?>

                <div class="col-12">
                    <?php
                        echo "<h2>" . esc_html__('Nothing found!', 'turitor') . "</h2>";
                        echo "<div>" . esc_html__('Sorry, but nothing matched your search terms. Please try again with different keywords.', 'turitor') . "</div>";
                    ?>
                </div>

                <?php
            }

            ?>
    </div>
          
    <?php

    wp_reset_query();



