<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Team_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-team';
    }

    public function get_title() {
        return esc_html__( 'Teams ', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-sitemap';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Teams settings', 'turitor'),
            ]
        );

        
      $this->add_control(
			'team_style',
			[
				'label' => esc_html__( 'team Style', 'turitor' ),
				'type' => Custom_Controls_Manager::IMAGECHOOSE,
            'default' => 'style1',
				'options' => [
					'style1' => [
                        'title'      => esc_html__( ' Style 1 ', 'turitor' ),
                        'imagelarge' =>  TURITOR_IMG. '/style/team/style1.png',
                        'imagesmall' =>  TURITOR_IMG. '/style/team/style1.png',
                        'width' => '30%',
				   	],
               'style2' => [
                     'title'      => esc_html__( ' Style 2 ', 'turitor' ),
                     'imagelarge' =>  TURITOR_IMG. '/style/team/style2.png',
                     'imagesmall' =>  TURITOR_IMG. '/style/team/style2.png',
                     'width' => '30%',
                  ],
               ],

			   ]
        );
     
      $this->add_control('team_count',
            [
               'label'         => esc_html__( 'team count', 'turitor' ),
               'type'          => Controls_Manager::NUMBER,
               'default'       => '3',
            ]
       );
        
      $this->add_control('team_category',
               [
                  'label'     => esc_html__( 'Category', 'turitor' ),
                  'type'      => \Elementor\Controls_Manager::SELECT,
                  'default'   => 'all',
                  'options'   => $this->getCategories(),
               
               ]
      );
    
      $this->add_control('show_filter',
            [
               'label'     => esc_html__('Show Filter', 'turitor'),
               'type'      => Controls_Manager::SWITCHER,
               'label_on'  => esc_html__('Yes', 'turitor'),
               'label_off' => esc_html__('No', 'turitor'),
               'default'   => 'yes',
               'condition' =>["team_style"=>["style1"] ],
         

            ]
        ); 

         
      $this->add_control('show_title_link',
         [
            'label'     => esc_html__('Show title link?', 'turitor'),
            'type'      => Controls_Manager::SWITCHER,
            'label_on'  => esc_html__('Yes', 'turitor'),
            'label_off' => esc_html__('No', 'turitor'),
            'default'   => 'no',
         ]
      ); 


       
      $this->end_controls_section();

      $this->start_controls_section('tab_menu',
            [
               'label' => esc_html__( 'Tab menu Section', 'turitor' ),
               'tab'   => Controls_Manager::TAB_STYLE,
            ]
      ); 
    
      $this->add_control('team_active_menu_color',
         [
            'label'    => esc_html__('Menu active bg color', 'turitor'),
            'type'     => Controls_Manager::COLOR,
            'selectors'   => [
                  '{{WRAPPER}} .team-tab-menu ul li.active, .team-tab-menu ul li:hover' => 'background-color: {{VALUE}};',
                  '{{WRAPPER}} .team-tab-menu ul li.active, .team-tab-menu ul li:hover' => 'border-color: {{VALUE}};',
               ],
         ]
      );
      $this->add_control('team_menu_color',
         [
            'label'    => esc_html__('Menu border color', 'turitor'),
            'type'     => Controls_Manager::COLOR,
            'selectors'   => [
                  '{{WRAPPER}} .team-tab-menu ul li' => 'border-color: {{VALUE}};',
               ],
         ]
      );


      $this->end_controls_section();


      $this->start_controls_section('style_section',
            [
               'label' => esc_html__( 'Style Section', 'turitor' ),
               'tab'   => Controls_Manager::TAB_STYLE,
            ]
        ); 

      $this->add_control('team_text_color',
            [
               'label'    => esc_html__('Title color', 'turitor'),
               'type'     => Controls_Manager::COLOR,
               'selectors'   => [
                     '{{WRAPPER}} .single-team-item .ts-team-title' => 'color: {{VALUE}};',
                     '{{WRAPPER}} .single-team-item .ts-team-title a' => 'color: {{VALUE}};',
                  ],
            ]
         );



      $this->add_control('team_text_color_hover',
         [
            'label'     => esc_html__('Title hover', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
             
                  '{{WRAPPER}} .single-team-item:hover .ts-team-title' => 'color: {{VALUE}};',
                  '{{WRAPPER}} .single-team-item:hover .ts-team-title a' => 'color: {{VALUE}};',
            
            ],
         ]
      );

      $this->add_group_control(
            Group_Control_Typography::get_type(), [
               'name'		 => 'turitor_team_title_typography',
               'label'    => esc_html__('Title Typhography', 'turitor'),
               'selector'	 => '{{WRAPPER}} .single-team-item .ts-team-title',
            ]
      );

         
      $this->add_control('team_desgination_color',
      [
         'label'    => esc_html__('Designation color', 'turitor'),
         'type'     => Controls_Manager::COLOR,
         'selectors'   => [
               '{{WRAPPER}} .single-team-item p' => 'color: {{VALUE}};',
            ],
      ]
   );



         $this->add_group_control(Group_Control_Typography::get_type(), 
         [
           'name'		 => 'turitor_designation_typography',
           'label'    => esc_html__('Designation Typhography', 'turitor'),
           'selector'	 => 
                  '{{WRAPPER}} .single-team-item p',
                 
         ]
       );

       $this->add_control('team_shap_color',
            [
               'label'    => esc_html__('Shape color', 'turitor'),
               'type'     => Controls_Manager::COLOR,
               'selectors'   => [
                     '{{WRAPPER}} .team-shap-1 path' => 'fill: {{VALUE}};',
                  ],
            ]
         );
       $this->add_control('team_shap_hover_color',
            [
               'label'    => esc_html__('Shape hover color', 'turitor'),
               'type'     => Controls_Manager::COLOR,
               'selectors'   => [
                     '{{WRAPPER}} .single-team-item:hover .team-shap-1 path' => 'fill: {{VALUE}};',
                  ],
            ]
         );

       $this->add_control('team_shap_2_color',
            [
               'label'    => esc_html__('Shape two color', 'turitor'),
               'type'     => Controls_Manager::COLOR,
               'selectors'   => [
                     '{{WRAPPER}} .team-shap-2 path:last-child' => 'fill: {{VALUE}};',
                  ],
            ]
         );

         $this->end_controls_section();  
      }
      protected function render( ) { 
        
         $settings      = $this->get_settings();
         $team_cat   = $settings["team_category"];
         $team_count = $settings["team_count"];
         $team_style = $settings["team_style"];
         $show_filter   = $settings["show_filter"];
         $show_title_link   = $settings["show_title_link"];
       
        
         $args = array(
            'numberposts'    => $team_count,
            'orderby'        => 'post_date',
            'order'          => 'DESC',
            'post_type'      => 'ts-teams',
            'post_status'    => 'publish',
            'tax_query'      => [],
          
        );
     
        if($team_cat!='all'){
            $args["tax_query"]  = array(
                array(
                    'taxonomy' => 'ts-team-cat',
                    'field'    => 'slug',
                    'terms'    => array($team_cat)
                )
            );
        }  
    
        $team_list = get_posts( $args );

        if($team_style=="style1"):   
         include (locate_template("components/editor/elementor/widgets/style/team/style1.php", false, false ));  
       endif;
      if($team_style=="style2"): 
            include (locate_template("components/editor/elementor/widgets/style/team/style2.php", false, false ));  
      endif;

       ?>
     

       <?php
      }

      public function getCategories(){
         $cat_list = [];
         if ( post_type_exists( 'ts-teams' ) ) { 
          $terms = get_terms( array(
             'taxonomy'    => 'ts-team-cat',
             'hide_empty'  => false,
             'number'      => '350', 
         ) );
            
         
         $cat_list['all']   = ['All'];
         foreach($terms as $post) {

          $cat_list[$post->slug]  = [$post->name];

         }
      }  
        return $cat_list;
     }
   }  
      
  