<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * customizer option: general
 */

$options =[
    'general_settings' => [
            'title'		 => esc_html__( 'General settings', 'turitor' ),
            'options'	 => [
                'preloader_show' => [
                    'type'			 => 'switch',
                    'label'		    => esc_html__( 'Preloader show', 'turitor' ),
                    'desc'			 => esc_html__( 'Do you want to show preloader on your site ?', 'turitor' ),
                    'value'         => 'no',
                    'left-choice'	 => [
                       'value'     => 'yes',
                       'label'	   => esc_html__( 'Yes', 'turitor' ),
                    ],
                    'right-choice'	 => [
                       'value'	 => 'no',
                       'label'	 => esc_html__( 'No', 'turitor' ),
                    ],
                  ],
                  'preloader_logo' => [
                    'label'	        => esc_html__( 'Preloader logo', 'turitor' ),
                    'desc'	           => esc_html__( 'When you enable preloader then you can set preloader image otherwise default color preloader you will see', 'turitor' ),
                    'type'	           => 'upload',
                    'image_only'      => true,
                 ],
                'general_main_logo' => [
                    'label'	        => esc_html__( 'Main logo', 'turitor' ),
                    'desc'	           => esc_html__( 'It\'s the main logo, mostly it will be shown on "dark or coloreful" type area.', 'turitor' ),
                    'type'	           => 'upload',
                    'image_only'      => true,
                 ],
                'general_footer_logo' => [
                    'label'	        => esc_html__( 'Footer logo', 'turitor' ),
                    'desc'	           => esc_html__( 'It will be shown on  footer logo.', 'turitor' ),
                    'type'	           => 'upload',
                    'image_only'      => true,
                 ],
                'offcanvas_logo' => [
                    'label'	        => esc_html__( 'Offcanvas logo', 'turitor' ),
                    'desc'	           => esc_html__( 'It will be shown on  offcanvas logo.', 'turitor' ),
                    'type'	           => 'upload',
                    'image_only'      => true,
                 ],
                 'blog_sticky_sidebar' => [
                    'type'			    => 'switch',
                    'label'			 => esc_html__( 'Sticky sidebar', 'turitor' ),
                    'desc'			    => esc_html__( 'Use sticky sidebar?', 'turitor' ),
                    'value'          => 'no',
                    'left-choice' => [
                        'value'	 => 'yes',
                        'label'	 => esc_html__( 'Yes', 'turitor' ),
                    ],
                    'right-choice' => [
                        'value'	 => 'no',
                        'label'	 => esc_html__( 'No', 'turitor' ),
                    ],
               ],
                'general_social_links' => [
                    'type'          => 'addable-popup',
                    'template'      => '{{- title }}',
                    'popup-title'   => null,
                    'label' => esc_html__( 'Social links', 'turitor' ),
                    'desc'  => esc_html__( 'Add social links and it\'s icon class bellow. These are all fontaweseome-4.7 icons.', 'turitor' ),
                    'add-button-text' => esc_html__( 'Add new', 'turitor' ),
                    'popup-options' => [
                        'title' => [ 
                            'type' => 'text',
                            'label'=> esc_html__( 'Title', 'turitor' ),
                        ],
                        'icon_class' => [ 
                            'type' => 'new-icon',
                            'label'=> esc_html__( 'Social icon', 'turitor' ),
                        ],
                        'url' => [ 
                            'type' => 'text',
                            'label'=> esc_html__( 'Social link', 'turitor' ),
                        ],
                    ],
                   
                ],
            ],
        ],
    ];
