<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * enqueue all theme scripts and styles
 */


// stylesheets
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {
	// wp_enqueue_style() $handle, $src, $deps, $version

	// 3rd party css
	wp_enqueue_style( 'turitor-fonts', turitor_google_fonts_url(['Roboto:300,300i,400,400i,500,500i,700,700i,900,900i', 'Rubik:400,400i,500,500i,700,700i,900,900i']), null, TURITOR_VERSION );

	if( is_rtl() ){
		wp_enqueue_style( 'bootstrap-rtl',  TURITOR_CSS . '/bootstrap.min-rtl.css', null,  TURITOR_VERSION );
		}else{
			wp_enqueue_style( 'bootstrap', TURITOR_CSS . '/bootstrap.min.css', null, TURITOR_VERSION );
	
		}
	
	wp_enqueue_style( 'fontawesome', TURITOR_CSS . '/fontawesome.min.css', null, TURITOR_VERSION );
	wp_enqueue_style( 'iconfont', TURITOR_CSS . '/iconfont.css', null, TURITOR_VERSION );
	wp_enqueue_style( 'magnific-popup', TURITOR_CSS . '/magnific-popup.css', null, TURITOR_VERSION );
	wp_enqueue_style( 'owl-carousel', TURITOR_CSS . '/owl.carousel.min.css', null, TURITOR_VERSION );
	wp_enqueue_style( 'turitor-woocommerce', TURITOR_CSS . '/woocommerce.css', null, TURITOR_VERSION );
  // gutenberg css
	wp_enqueue_style( 'turitor-gutenberg-custom', TURITOR_CSS . '/gutenberg-custom.css', null, TURITOR_VERSION );
	// theme css
	wp_enqueue_style( 'turitor-style', TURITOR_CSS . '/master.css', null, TURITOR_VERSION );

	if (class_exists('BuddyPress')) {
		wp_enqueue_style( 'buddypress', TURITOR_CSS . '/buddypress.css', null, TURITOR_VERSION );
	}
	
}

// javascripts
// ----------------------------------------------------------------------------------------
if ( !is_admin() ) {

	// 3rd party scripts
	if ( is_rtl() ) {
		wp_enqueue_script( 'bootstrap-rtl', TURITOR_JS . '/bootstrap.min-rtl.js', array( 'jquery' ), TURITOR_VERSION, true );
	}else{
		wp_enqueue_script( 'bootstrap', TURITOR_JS . '/bootstrap.min.js', array( 'jquery' ), TURITOR_VERSION, true );
	}

	wp_enqueue_script( 'popper', TURITOR_JS . '/popper.min.js', array( 'jquery' ), TURITOR_VERSION, true );
	wp_enqueue_script( 'magnific-popup', TURITOR_JS . '/jquery.magnific-popup.min.js', array( 'jquery' ), TURITOR_VERSION, true );
	wp_enqueue_script( 'jquery-mixtub',  TURITOR_JS . '/jquery-mixtub.js', array( 'jquery' ),  TURITOR_VERSION, true );
	wp_enqueue_script( 'owl-carousel', TURITOR_JS . '/owl.carousel.min.js', array( 'jquery' ), TURITOR_VERSION, true );
	wp_enqueue_script( 'jquery-easypiechart', TURITOR_JS . '/jquery.easypiechart.min.js', array( 'jquery' ), TURITOR_VERSION, true );
	wp_enqueue_script('jquery-repeater-min', TURITOR_JS . '/jquery.repeater.min.js', array('jquery'), TURITOR_VERSION, false);
	// theme scripts
	wp_enqueue_script( 'turitor-script', TURITOR_JS . '/script.js', array( 'jquery' ), TURITOR_VERSION, true );


	$blog_sticky_sidebar  = turitor_option('blog_sticky_sidebar');  

	wp_localize_script( 'turitor-script', 'turitor_obj', array(
	   
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'nonce' => wp_create_nonce('instructor_rest'),
		'security' => wp_create_nonce( 'load_more_posts' ),
		'blog_sticky_sidebar' => $blog_sticky_sidebar,

		'logged_in' =>is_user_logged_in(),
		'message_login'=> esc_html__('You are not logged in','turitor')
			 
		) );
	// Load WordPress Comment js
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}


