<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * helper functions
 */



// simply echo the variable
// ----------------------------------------------------------------------------------------
function turitor_return($s)
{
	return $s;
}

function turitor_course_content()
{

	global $post;
	setup_postdata($post);
	the_content();
}


function turitor_course_total_rating($ids)
{
	$sum = 0;
	$incremental = 0;
	$return_data = [
		'sum' => $sum, 'count' => $incremental
	];
	if (!is_array($ids) || !defined('WUR_REVIEW_KEY')) {
		return $return_data;
	}

	foreach ($ids as $id) {
		$data = review_kit_rating(['post-id' =>  $id, 'ratting-show' => 'no', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'no', 'vote-text' => 'no', 'return-type' => 'total_review']);
		if ($data) {
			$incremental++;
		}
		$sum += $data;
	}
	$return_data['sum'] = $sum;
	$return_data['count'] = $incremental;
	return $return_data;
}
// return the specific value from theme options/ customizer/ etc
// ----------------------------------------------------------------------------------------
function turitor_option($key, $default_value = '', $method = 'customizer')
{
	if (defined('FW')) {
		switch ($method) {
			case 'theme-settings':
				$value = fw_get_db_settings_option($key);
				break;
			case 'customizer':
				$value = fw_get_db_customizer_option($key);
				break;
			default:
				$value = '';
				break;
		}
		return (!isset($value) || $value == '') ? $default_value :  $value;
	}
	return $default_value;
}



// return the specific value from metabox
// ----------------------------------------------------------------------------------------
function turitor_meta_option($postid, $key, $default_value = '')
{
	if (defined('FW')) {
		$value = fw_get_db_post_option($postid, $key, $default_value);
	}
	return (!isset($value) || $value == '') ? $default_value :  $value;
}

function turitor_term_meta_option($term_id, $taxonomy = 'category', $option_id, $default_value = null)
{
	if (defined('FW')) {
		$value = fw_get_db_term_option($term_id, $taxonomy, $option_id, $default_value);
	}
	return (!isset($value) || $value == '') ? $default_value :  $value;
}

// unyson based image resizer
// ----------------------------------------------------------------------------------------
function turitor_resize($url, $width = false, $height = false, $crop = false)
{
	if (function_exists('fw_resize')) {
		$fw_resize	 = FW_Resize::getInstance();
		$response	 = $fw_resize->process($url, $width, $height, $crop);
		return (!is_wp_error($response) && !empty($response['src'])) ? $response['src'] : $url;
	} else {
		$response = wp_get_attachment_image_src($url, array($width, $height));
		if (!empty($response)) {
			return $response[0];
		}
	}
}


// extract unyson image data from option value in a much simple way
// ----------------------------------------------------------------------------------------
function turitor_src($key, $default_value = '', $input_as_attachment = false)
{ // for src
	if ($input_as_attachment == true) {
		$attachment = $key;
	} else {
		$attachment = turitor_option($key);
	}

	if (isset($attachment['url']) && !empty($attachment)) {
		return $attachment['url'];
	}

	return $default_value;
}


// return attachment alt in safe mode
// ----------------------------------------------------------------------------------------
function turitor_alt($id)
{
	if (!empty($id)) {
		$alt = get_post_meta($id, '_wp_attachment_image_alt', true);
		if (!empty($alt)) {
			$alt = $alt;
		} else {
			$alt = get_the_title($id);
		}
		return $alt;
	}
}


// get original id in WPML enabled WP
// ----------------------------------------------------------------------------------------
function turitor_org_id($id, $name = true)
{
	if (function_exists('icl_object_id')) {
		$id = icl_object_id($id, 'page', true, 'en');
	}

	if ($name === true) {
		$post = get_post($id);
		return $post->post_name;
	} else {
		return $id;
	}
}


// converts rgb color code to hex format
// ----------------------------------------------------------------------------------------
function turitor_rgb2hex($hex)
{
	$hex		 = preg_replace("/^#(.*)$/", "$1", $hex);
	$rgb		 = array();
	$rgb['r']	 = hexdec(substr($hex, 0, 2));
	$rgb['g']	 = hexdec(substr($hex, 2, 2));
	$rgb['b']	 = hexdec(substr($hex, 4, 2));

	$color_hex = $rgb["r"] . ", " . $rgb["g"] . ", " . $rgb["b"];
	return $color_hex;
}


// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function turitor_kses($raw)
{

	$allowed_tags = array(
		'a'								 => array(
			'class'	 => array(),
			'href'	 => array(),
			'rel'	 => array(),
			'title'	 => array(),
			'target' => array(),
		),
		'abbr'							 => array(
			'title' => array(),
		),
		'b'								 => array(),
		'blockquote'					 => array(
			'cite' => array(),
		),
		'cite'							 => array(
			'title' => array(),
		),
		'code'							 => array(),
		'del'							 => array(
			'datetime'	 => array(),
			'title'		 => array(),
		),
		'dd'							 => array(),
		'div'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'dl'							 => array(),
		'dt'							 => array(),
		'em'							 => array(),
		'h1'							 => array(),
		'h2'							 => array(),
		'h3'							 => array(),
		'h4'							 => array(),
		'h5'							 => array(),
		'h6'							 => array(),
		'i'								 => array(
			'class' => array(),
		),
		'img'							 => array(
			'alt'	 => array(),
			'class'	 => array(),
			'height' => array(),
			'src'	 => array(),
			'width'	 => array(),
		),
		'li'							 => array(
			'class' => array(),
		),
		'ol'							 => array(
			'class' => array(),
		),
		'p'								 => array(
			'class' => array(),
		),
		'q'								 => array(
			'cite'	 => array(),
			'title'	 => array(),
		),
		'span'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'iframe'						 => array(
			'width'			 => array(),
			'height'		 => array(),
			'scrolling'		 => array(),
			'frameborder'	 => array(),
			'allow'			 => array(),
			'src'			 => array(),
		),
		'strike'						 => array(),
		'br'							 => array(),
		'strong'						 => array(),
		'data-wow-duration'				 => array(),
		'data-wow-delay'				 => array(),
		'data-wallpaper-options'		 => array(),
		'data-stellar-background-ratio'	 => array(),
		'ul'							 => array(
			'class' => array(),
		),
	);

	if (function_exists('wp_kses')) { // WP is here
		$allowed = wp_kses($raw, $allowed_tags);
	} else {
		$allowed = $raw;
	}


	return $allowed;
}


// build google font url
// ----------------------------------------------------------------------------------------
function turitor_google_fonts_url($font_families	 = [])
{
	$fonts_url		 = '';
	if ($font_families) {
		$query_args = array(
			'family' => urlencode(implode('|', $font_families))
		);

		$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url);
}


// return megamenu child item's slug
// ----------------------------------------------------------------------------------------
function turitor_get_mega_item_child_slug($location, $option_id)
{
	$mega_item	 = '';
	$locations	 = get_nav_menu_locations();
	$menu		 = wp_get_nav_menu_object($locations[$location]);
	$menuitems	 = wp_get_nav_menu_items($menu->term_id);

	foreach ($menuitems as $menuitem) {

		$id			 = $menuitem->ID;
		$mega_item	 = fw_ext_mega_menu_get_db_item_option($id, $option_id);
	}
	return $mega_item;
}


// return cover image from an youtube video url
// ----------------------------------------------------------------------------------------
function turitor_youtube_cover($e)
{
	$src = null;
	//get the url
	if ($e != '') {
		$url = $e;
		$queryString = parse_url($url, PHP_URL_QUERY);
		parse_str($queryString, $params);
		$v = $params['v'];
		//generate the src
		if (strlen($v) > 0) {
			$src = "http://i3.ytimg.com/vi/$v/default.jpg";
		}
	}

	return $src;
}


// return embed code for sound cloud
// ----------------------------------------------------------------------------------------
function turitor_soundcloud_embed($url)
{
	return 'https://w.soundcloud.com/player/?url=' . urlencode($url) . '&auto_play=false&color=915f33&theme_color=00FF00';
}


// return embed code video url
// ----------------------------------------------------------------------------------------
function turitor_video_embed($url)
{
	//This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$embed_url = '';
	if (strpos($url, 'facebook.com/') !== false) {
		//it is FB video
		$embed_url = 'https://www.facebook.com/plugins/video.php?href=' . rawurlencode($url) . '&show_text=1&width=200';
	} else if (strpos($url, 'vimeo.com/') !== false) {
		//it is Vimeo video
		$video_id = explode("vimeo.com/", $url)[1];
		if (strpos($video_id, '&') !== false) {
			$video_id = explode("&", $video_id)[0];
		}
		$embed_url = 'https://player.vimeo.com/video/' . $video_id;
	} else if (strpos($url, 'youtube.com/') !== false) {
		//it is Youtube video
		$video_id = explode("v=", $url)[1];
		if (strpos($video_id, '&') !== false) {
			$video_id = explode("&", $video_id)[0];
		}
		$embed_url = 'https://www.youtube.com/embed/' . $video_id;
	} else if (strpos($url, 'youtu.be/') !== false) {
		//it is Youtube video
		$video_id = explode("youtu.be/", $url)[1];
		if (strpos($video_id, '&') !== false) {
			$video_id = explode("&", $video_id)[0];
		}
		$embed_url = 'https://www.youtube.com/embed/' . $video_id;
	} else {
		//for new valid video URL
	}
	return $embed_url;
}

if (!function_exists('turitor_advanced_font_styles')) :

	/**
	 * Get shortcode advanced Font styles
	 *
	 */
	function turitor_advanced_font_styles($style)
	{

		$font_styles = $font_weight = '';

		$font_weight = (isset($style['font-weight']) && $style['font-weight']) ? 'font-weight:' . esc_attr($style['font-weight']) . ';' : '';
		$font_weight = (isset($style['variation']) && $style['variation']) ? 'font-weight:' . esc_attr($style['variation']) . ';' : $font_weight;

		$font_styles .= isset($style['family']) ? 'font-family:"' . $style['family'] . '";' : '';
		$font_styles .= isset($style['style']) && $style['style'] ? 'font-style:' . esc_attr($style['style']) . ';' : '';

		$font_styles .= isset($style['color']) && !empty($style['color']) ? 'color:' . esc_attr($style['color']) . ';' : '';
		$font_styles .= isset($style['line-height']) && !empty($style['line-height']) ? 'line-height:' . esc_attr($style['line-height']) . 'px;' : '';
		$font_styles .= isset($style['letter-spacing']) && !empty($style['letter-spacing']) ? 'letter-spacing:' . esc_attr($style['letter-spacing']) . 'px;' : '';
		$font_styles .= isset($style['size']) && !empty($style['size']) ? 'font-size:' . esc_attr($style['size']) . 'px;' : '';

		$font_styles .= !empty($font_weight) ? $font_weight : '';

		return !empty($font_styles) ? $font_styles : '';
	}

endif;

function turitor_get_total_quize($sections)
{
	$i = 0;
	if (!is_array($sections)) {
		return 0;
	}
	try {
		foreach ($sections  as $section) {
			$lessons = $section->get_items();
			foreach ($lessons as $lesson) {

				if ($lesson->get_item_type() == 'lp_quiz') {
					$i++;
				} //endif 

			} // lessons
		} //sections
		return $i;
	} catch (Exception $e) {
		return 0;
	}

	return $i;
}

function turitor_co_instructor()
{

	$instructor_list = [];
	$instructors = get_users('orderby=nicename&role=lp_teacher');
	foreach ($instructors as $postdata) {
		setup_postdata($postdata);
		$instructor_list[$postdata->ID] = [$postdata->display_name];
	}

	return $instructor_list;
}

function turitor_related_posts_by_tags($post_id = '', $related_count = 4, $feature_image = true)
{

	try {
		if ($post_id == '') {
			$post_id = get_the_ID();
		}
		$tags  =  get_the_terms(get_the_id(), 'course_tag');

		if (!$tags) {
			return [];
		}

		$term_tags = wp_list_pluck($tags, 'term_id');

		$args = array(
			'post_type' => 'lp_course',
			'post__not_in' => array($post_id),
			'posts_per_page' => $related_count,
			'ignore_sticky_posts' => 1,
			'tax_query' => array(
				array(
					'taxonomy' => 'course_tag',
					'terms' => $term_tags,
					'field' => 'id',
					'operator' => 'IN'
				)
			),
		);
		if ($feature_image) {
			$args["meta_query"] = array(
				array(
					'key' => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
			);
		}

		return get_posts($args);
	} catch (Exception $e) {

		return [];
	}
}

function turitor_array_elements_remove($input, $elements)
{

	$body_array = explode(';', $input);

	unset($body_array[$elements]);
	return implode(";", $body_array);
}

// review rating
function turitor_review_rating($arg = [])
{
	if (function_exists('review_kit_rating')) {
		return review_kit_rating($arg);
	}
}
// events speaker
function turitors_get_speakers()
{
	$speakers = [];
	$args = array(

		'post_type'   => 'turitor-speakers',
		'orderby' => 'post_date',
		'order' => 'DESC',
		'post_status'  => 'publish',
		'posts_per_page' => -1

	);

	$tu_spaeker = get_posts($args);

	foreach ($tu_spaeker as $postdata) {
		setup_postdata($postdata);
		$speakers[$postdata->ID] = [$postdata->post_title];
	}


	return $speakers;
}

function turitor_get_users_by_id($id = null)
{

	if (is_null($id)) {
		return [];
	}
	try {
		if (is_array($id)) {
			if (count($id) == 0) {
				return [];
			}
		}
		$include_list = $id;

		$args = array(
			'include' => $include_list
		);

		$instructors = new WP_User_Query($args);
		$teachers = $instructors->get_results();
		return $teachers;
	} catch (Exception $e) {
		return [];
	}
}

function digiqole_review_score_limit($id)
{
?>
	<div class="digiqole-rating">
		<?php
		$rating = digiqole_review_rating(['post-id' =>  $id,  'ratting-show' => 'no', 'count-show' => 'yes', 'vote-show' => 'no', 'vote-text' => 'no'], 'only_ratting');

		$return_data_global_setting = get_option('xs_review_global');
		$score_limit =  (isset($return_data_global_setting['review_score_limit']) && $return_data_global_setting['review_score_limit'] != '0') ? $return_data_global_setting['review_score_limit'] : '5';
		$rating_parcent = ($rating / $score_limit) * 100;
		?>
		<div class="digiqole-review-percent">

			<?php
			echo '<i class="tsicon icon-star"></i>';
			echo  esc_html($rating);
			?>

		</div>
	</div>

<?php

}


function turitor_course_cageory_by_id($post_id = null, $single = true)
{
	$terms = get_the_terms($post_id, 'course_category');
	$cat = '';
	$cat_with_link = '';

	if (is_array($terms)) :

		foreach ($terms as $tkey => $term) :

			$cat .= $term->slug . ' ';

			$cat_with_link .= sprintf("<a href='%s'>%s</a>", get_category_link($term->term_id), $term->name);

			if ($single) {
				break;
			}

			if ($tkey == 1) {
				break;
			}

		endforeach;

	endif;
	return $cat_with_link;
}
function turitor_ld_course_cageory_by_id($post_id = null, $course_category, $single = true)
{
	$terms = get_the_terms($post_id,  $course_category);
	$cat = '';
	$cat_with_link = '';

	if (is_array($terms)) :

		foreach ($terms as $tkey => $term) :

			$cat .= $term->slug . ' ';

			$cat_with_link .= sprintf("<a href='%s'>%s</a>", get_category_link($term->term_id), $term->name);

			if ($single) {
				break;
			}

			if ($tkey == 1) {
				break;
			}

		endforeach;

	endif;
	return $cat_with_link;
}


function turitor_follow_instructor_by_id($id)
{

	if (is_null($id) || $id == '') {
		return;
	}

	$key = 'turitor_following_instructors';
	$prev_follow =  get_user_meta(get_current_user_id(), $key, true);

	if (!$prev_follow) {
		$prev_follow = (array) $prev_follow;
		array_push($prev_follow, $id);
		update_user_meta(get_current_user_id(), $key, $prev_follow);
		return;
	} else {

		array_push($prev_follow, $id);
		array_unique($prev_follow);
		$prev_follow = array_values(array_unique($prev_follow));
		update_user_meta(get_current_user_id(), $key, $prev_follow);
		return;
	}
}

function turitor_course_popular_ids()
{
	global $wpdb;
	if (!defined('LP_COURSE_CPT')) {
		return;
	}
	$limit = LP()->settings->get('learn_press_archive_course_limit');
	$query = $wpdb->prepare("
		SELECT ID, a+IF(b IS NULL, 0, b) AS students FROM(
			SELECT p.ID as ID, IF(pm.meta_value, pm.meta_value, 0) as a, (
		SELECT COUNT(*)
	FROM (SELECT COUNT(item_id), item_id, user_id FROM {$wpdb->prefix}learnpress_user_items GROUP BY item_id, user_id) AS Y
	GROUP BY item_id
	HAVING item_id = p.ID
	) AS b
	FROM {$wpdb->posts} p
	LEFT JOIN {$wpdb->postmeta} AS pm ON p.ID = pm.post_id  AND pm.meta_key = %s
	WHERE p.post_type = %s AND p.post_status = %s
	GROUP BY ID
	) AS Z
	ORDER BY students DESC
		LIMIT 0, $limit
	", '_lp_students', 'lp_course', 'publish');

	$post_in = $wpdb->get_col($query);
	return $post_in;
}

function turitor_follower_instructor_by_id($instructor_id)
{

	if (is_null($instructor_id) || $instructor_id == '') {
		return;
	}

	$key = 'turitor_follower_instructors';
	$user = get_current_user_id();
	$prev_follow =  get_user_meta($instructor_id, $key, true);

	if (!$prev_follow) {
		$prev_follow = (array) $prev_follow;
		array_push($prev_follow, $user);
		update_user_meta($instructor_id, $key, $prev_follow);
		return;
	} else {

		array_push($prev_follow, $user);
		array_unique($prev_follow);
		$prev_follow = array_values(array_unique($prev_follow));
		update_user_meta($instructor_id, $key, $prev_follow);
		return;
	}
}

function turitor_demo_data_export($tables = ['users', 'usermeta'])
{
	global $wpdb;
	$data = [];
	$tpl = [];
	$rows = [];
	if (is_array($tables)) {
		foreach ($tables as $name) {
			$columns = $wpdb->get_results('SHOW COLUMNS FROM ' . $wpdb->prefix . esc_sql($name), ARRAY_A);
			$rows_column = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . esc_sql($name), ARRAY_A);
			$tpl[$name] = $wpdb->get_col('SHOW CREATE TABLE ' . $wpdb->prefix . esc_sql($name), 1);
			$rows[$name] = $rows_column;
		}
		$data['tables'] = $tpl;
		$data['rows'] = $rows;
	}
	return json_encode($data);
}

function turitor_database_table_data_import($content = [], $tables = ['users'])
{

	global $wpdb;

	if (is_array($content) && is_array($tables)) {

		$user_table_exist = false;
		$user_table_exist = in_array('users', $tables);

		if (!isset($content['rows'])) {
			return false;
		}

		$tables_data = $content['rows'];
		foreach ($tables_data as $table_name => $table_row) {

			if ($user_table_exist && $table_name == 'users') {

				turitor_update_user_table($table_row);
			} elseif ($user_table_exist && $table_name == 'usermeta') {

				turitor_update_usermeta_table($table_row);
			} else {
			} // for other customs tables

		}
	}
}

function turitor_update_user_table($content)
{
	global $wpdb;

	if (!is_array($content)) {
		return;
	}

	$table = $wpdb->prefix . 'users';

	foreach ($content as $row) {
		$user_exist = get_userdata($row['ID']);
		if (isset($row['ID']) && $row['ID'] == 1) {
			continue;
		}

		if ($user_exist && user_can($row['ID'], 'administrator')) {
			continue;
		}

		if (!$user_exist) {
			$wpdb->insert($table, $row);
		}
	}
}

function turitor_update_usermeta_table($content)
{

	global $wpdb;
	if (!is_array($content)) {
		return;
	}

	$table = $wpdb->prefix . 'usermeta';
	$umeta_id = $wpdb->get_results('SELECT umeta_id FROM ' . $table, ARRAY_A);
	$usermeta_id =  wp_list_pluck($umeta_id, 'umeta_id');

	foreach ($content as $row) {

		$user_exist = get_userdata(esc_sql($row['user_id']));
		if (isset($row['ID']) && $row['user_id'] == 1) {
			continue;
		}

		if ($user_exist && user_can($row['user_id'], 'administrator')) {
			continue;
		}

		$column_exist = false;
		if (is_array($usermeta_id) && in_array($row['umeta_id'], $usermeta_id)) {
			$column_exist = true;
		}

		if (!$column_exist) {
			$wpdb->insert($table, $row);
		}
	}
}

function turitor_demo_content_unserialize($content = '')
{

	$data = json_decode($content, true);
	if (is_array($data)) {
		return $data;
	}
	return [];
}

if (!function_exists('turitor_fontawesome_icons')) {

	function turitor_fontawesome_icons($prefix = 'fab')
	{
		$prefix = apply_filters('turitor_social_icons_prefix', $prefix);
		$social_icons = array(
			"$prefix fa-facebook" => esc_html__('facebook', 'turitor'),
			"$prefix fa-facebook-f" => esc_html__('facebook-f', 'turitor'),
			"$prefix fa-facebook-messenger" => esc_html__('facebook-messenger', 'turitor'),
			"$prefix fa-facebook-square" => esc_html__('facebook-square', 'turitor'),
			"$prefix fa-linkedin" => esc_html__('linkedin', 'turitor'),
			"$prefix fa-linkedin-in" => esc_html__('linkedin-in', 'turitor'),
			"$prefix fa-twitter" => esc_html__('twitter', 'turitor'),
			"$prefix fa-twitter-square" => esc_html__('twitter-square', 'turitor'),
			"$prefix fa-uber" => esc_html__('uber', 'turitor'),
			"$prefix fa-google" => esc_html__('google', 'turitor'),
			"$prefix fa-google-drive" => esc_html__('google-drive', 'turitor'),
			"$prefix fa-google-play" => esc_html__('google-play', 'turitor'),
			"$prefix fa-google-wallet" => esc_html__('google-wallet', 'turitor'),
			"$prefix fa-linkedin" => esc_html__('linkedin', 'turitor'),
			"$prefix fa-linkedin-in" => esc_html__('linkedin-in', 'turitor'),
			"$prefix fa-whatsapp" => esc_html__('whatsapp', 'turitor'),
			"$prefix fa-whatsapp-square" => esc_html__('whatsapp-square', 'turitor'),
			"$prefix fa-wordpress" => esc_html__('wordpress', 'turitor'),
			"$prefix fa-wordpress-simple" => esc_html__('wordpress-simple', 'turitor'),
			"$prefix fa-youtube" => esc_html__('youtube', 'turitor'),
			"$prefix fa-youtube-square" => esc_html__('youtube-square', 'turitor'),
			"$prefix fa-xbox" => esc_html__('xbox', 'turitor'),
			"$prefix fa-vk" => esc_html__('vk', 'turitor'),
			"$prefix fa-vnv" => esc_html__('vnv', 'turitor'),
			"$prefix fa-instagram" => esc_html__('instagram', 'turitor'),
			"$prefix fa-reddit" => esc_html__('reddit', 'turitor'),
			"$prefix fa-reddit-alien" => esc_html__('reddit-alien', 'turitor'),
			"$prefix fa-reddit-square" => esc_html__('reddit-square', 'turitor'),
			"$prefix fa-pinterest" => esc_html__('pinterest', 'turitor'),
			"$prefix fa-pinterest-p" => esc_html__('pinterest-p', 'turitor'),
			"$prefix fa-pinterest-square" => esc_html__('pinterest-square', 'turitor'),
			"$prefix fa-tumblr" => esc_html__('tumblr', 'turitor'),
			"$prefix fa-tumblr-square" => esc_html__('tumblr-square', 'turitor'),
			"$prefix fa-flickr" => esc_html__('flickr', 'turitor'),
			"$prefix fa-meetup" => esc_html__('meetup', 'turitor'),
			"$prefix fa-share" => esc_html__('share', 'turitor'),
			"$prefix fa-vimeo-v" => esc_html__('vimeo', 'turitor'),
			"$prefix fa-weixin" => esc_html__('Wechat', 'turitor'),


		);

		return apply_filters('turitor_social_icons', $social_icons);
	}
}


function turitor_cart_count() {
	if (!LP()->get_cart()->is_empty()) {
		echo count(LP()->get_cart()->get_items());
	} else {
		echo esc_html__('0', 'turitor');
	}
}

function turitor_remote_file_exists($url)
{
	$response = wp_remote_head($url);
	return 200 === wp_remote_retrieve_response_code($response);
}

function turitor_get_remote_demo_data($url = '')
{
	return wp_remote_get($url);
}

// LearnPress Skill labels added in admin tabs
add_filter('learn_press_admin_tabs_info', 'turitor_admin_tabs_info');
function turitor_admin_tabs_info($tabs){
	$post_type = filter_input(INPUT_GET, 'post_type');
	if(LP_COURSE_CPT == $post_type){
		$tabs[35]=array(
			'link'	=> 'edit-tags.php?taxonomy=ts-skill-label&post_type=lp_course',
			'name'	=>esc_html__('Skills Labels', 'turitor'),
			'id'	=>'ts-skill-label'
		);
	}
	return $tabs;
}


// turitor group banner 
if( ! function_exists( 'turitor_bp_group_banner' ) ) {
	function turitor_bp_group_banner(){
		?>
			<div class="bp-banner">
				<div class="container">
					<div class="row">
						<div class="col-lg-12 text-center">
							<div class="banner-content">
								<h2><?php echo esc_html__('All Groups','turitor'); ?></h2>
								<?php /* Backward compatibility for inline search form. Use template part instead. */ ?>
									<?php if ( has_filter( 'bp_directory_groups_search_form' ) ) : ?>
	
										<div id="group-dir-search" class="dir-search" role="search">
											<?php bp_directory_groups_search_form(); ?>
										</div><!-- #group-dir-search -->
	
									<?php else: ?>
	
										<?php bp_get_template_part( 'common/search/dir-search-form' ); ?>
	
									<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div> <!-- ./ banner -->
		<?php
	}
}

// turitor member 
if(!function_exists('turitor_bp_member_item')){
	function turitor_bp_member_item(){
		?>
			<div class="bp-single-item">
				<div class="item-avatar">
					<?php // Get the Cover Image

						$member_cover_image_url = bp_attachments_get_attachment('url', array(
							'object_dir' => 'members',
							'item_id' => bp_get_member_user_id(),
						));

						if($member_cover_image_url == ''){
							$member_cover_image_url = TURITOR_IMG.'/banner/banner_image.jpg';
						}
					?>
					<div class="author-area" style="background-image: url('<?php echo esc_url($member_cover_image_url); ?>')">
						<a href="<?php bp_member_permalink(); ?>"><?php bp_member_avatar(); ?></a>
					</div>
				</div>

				<div class="item">
					<div class="item-title">
						<a href="<?php bp_member_permalink(); ?>"><?php bp_member_name(); ?></a>
					</div>

					<div class="item-meta">
						<span class="activity" data-livestamp="<?php bp_core_iso8601_date( bp_get_member_last_active( array( 'relative' => false ) ) ); ?>"><?php bp_member_last_active(); ?></span>
					</div>
					<ul class="team-follower list-unstyled">
						<li>
							<?php echo bp_total_friend_count( bp_get_member_user_id());	?>
							<span>
								<?php echo esc_html__(' Friends','turitor'); ?>
							</span>
						</li>
							<li>
								<?php 
									$groups_for_member = groups_get_user_groups( bp_get_member_user_id());
									echo esc_html($groups_for_member['total']);
								?>
								<span><?php echo esc_html__('Groups','turitor'); ?></span>
								
							</li>
						<li>
							<?php
								echo esc_html(get_activity_count_by_user(bp_get_member_user_id()));
							?> 
							<span>
								<?php
									echo esc_html__(' Posts','turitor');
								?> 
							</span>
						</li>
					</ul>

					<?php

					/**
					 * Fires inside the display of a directory member item.
					 *
					 * @since 1.1.0
					 */
					do_action( 'bp_directory_members_item' ); ?>

					<?php
					/***
					 * If you want to show specific profile fields here you can,
					* but it'll add an extra query for each member in the loop
					* (only one regardless of the number of fields you show):
					*
					* bp_member_profile_data( 'field=the field name' );
					*/
					?>
					<div class="user-meta">
						<div class="user-btn">
							<?php do_action( 'bp_directory_members_actions' ); ?>
						</div>
						<div class="user-btn">
							<a href="<?php bp_member_permalink(); ?>">
								<?php echo esc_html__('Profile','turitor'); ?>
							</a>
						</div>
					</div>
				</div>
			</div>
		<?php
	}
}

// turitor group 
if(!function_exists('turitor_bp_group_item')){
	function turitor_bp_group_item(){
		$group_cover_image_url = bp_attachments_get_attachment('url', array(
			'object_dir' => 'members',
			'item_id' => bp_get_member_user_id(),
		));

		if($group_cover_image_url == ''){
			$group_cover_image_url = TURITOR_IMG.'/banner/banner_image.png';
		}
		?>
		<div class="bp-single-item bp-single-group"  style="background-image: url('<?php echo esc_url($group_cover_image_url); ?>')">
			<?php if ( ! bp_disable_group_avatar_uploads() ) : ?>
				<div class="item-avatar">
					<div class="author-area">
						<a href="<?php bp_group_permalink(); ?>"><?php bp_group_avatar( 'type=thumb&width=50&height=50' ); ?></a>
					</div>
				</div>
			<?php endif; ?>

			<div class="item">
				<div class="item-title"><?php bp_group_link(); ?></div>
				<div class="item-meta">
					<div class="div">
						<span class="activity" data-livestamp="<?php bp_core_iso8601_date( bp_get_group_last_active( 0, array( 'relative' => false ) ) ); ?>">
							<?php
							/* translators: %s: last activity timestamp (e.g. "Active 1 hour ago") */
							printf( __( 'Active %s', 'turitor' ), bp_get_group_last_active() );
							?>
						</span>
					</div>
					<div class="div">
						<span class="activity group-activity">
									<?php bp_group_type(); ?> / <?php bp_group_member_count(); ?>
						</span>
							<?php
								do_action( 'bp_directory_groups_actions' ); 
							?>
					</div>
				</div>
			</div>
		</div>
	<?php
	}
}

// turitor forum 

if(!function_exists('turitor_bp_forum_item')){ 
	function turitor_bp_forum_item($topic_count, $loadmore = 'yes'){
		$activity_latest_args['per_page'] = $topic_count;
		?>
			<?php if ( bp_has_activities( $activity_latest_args ) ) : ?>
				<?php if ( empty( $_POST['page'] ) ) : ?>
					<ul id="activity-stream" class="activity-list item-list">
				<?php endif; ?>
				<?php while ( bp_activities() ) : bp_the_activity(); ?>
					<?php bp_get_template_part( 'activity/entry' ); ?>
				<?php endwhile; ?>
				<?php if($loadmore == 'yes'): ?>
					<?php if ( bp_activity_has_more_items() ) : ?>
						<li class="load-more">
							<a href="<?php bp_activity_load_more_link() ?>"><?php esc_html_e( 'Load More', 'turitor' ); ?></a>
						</li>
					<?php endif; ?>
				<?php endif; ?>
				<?php if ( empty( $_POST['page'] ) ) : ?>
					</ul>
				<?php endif; ?>
				<?php else : ?>
				<div id="message" class="info">
					<p><?php esc_html_e( 'Sorry, there was no activity found. Please try a different filter.', 'turitor' ); ?></p>
				</div>

				<?php endif; ?>
		<?php
	}
}
