<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * dynamic css, generated by customizer options
 */

// display navigation to the next/previous set of posts
// ----------------------------------------------------------------------------------------
function turitor_post_nav() {
// Don't print empty markup if there's nowhere to navigate.
	$next_post	 = get_next_post();
	$pre_post	 = get_previous_post();
	if ( !$next_post && !$pre_post ) {
		return;
	}
?>
	<nav class="post-navigation clearfix">
		<div class="post-previous">
			<?php if ( !empty( $pre_post ) ): ?>
				<a href="<?php echo get_the_permalink( $pre_post->ID ); ?>">
					<h3><?php echo get_the_title( $pre_post->ID ) ?></h3>
					<span><i class="fas fa-long-arrow-alt-left"></i><?php esc_html_e( 'Previous post', 'turitor' ) ?></span>
				</a>
			<?php endif; ?>
		</div>
		<div class="post-next">
			<?php if ( !empty( $next_post ) ): ?>
				<a href="<?php echo get_the_permalink( $next_post->ID ); ?>">
					<h3><?php echo get_the_title( $next_post->ID ) ?></h3>

					<span><?php esc_html_e( 'Next post', 'turitor' ) ?> <i class="fas fa-long-arrow-alt-right"></i></span>
				</a>
			<?php endif; ?>
		</div>
	</nav>
<?php }


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function turitor_get_breadcrumbs( $seperator = '', $word = '' ) {
	if ( defined( 'FW' ) ) {
		$word = turitor_option( 'breadcrumb_length' );
	}
	
	 
	echo '<ol class="breadcrumb" data-wow-duration="2s">';
	if ( !is_home() ) {
		echo '<li><a href="';
		echo esc_url( get_home_url( '/' ) );
		echo '">';
		echo esc_html__( 'Home', 'turitor' );
		echo "</a></li> " . '/';
		if ( is_category() || is_single() ) {
			echo '<li>';
			$category	 = get_the_category();
			$post		 = get_queried_object();
			$postType	 = get_post_type_object( get_post_type( $post ) );
			
			if ( !empty( $category ) ) {
				echo esc_html( $category[ 0 ]->cat_name ) . '</li>';
			}else if(defined('LP_COURSE_CPT') && is_category()){
				 single_cat_title();
			} else if ( $postType ) {
				echo esc_html( $postType->labels->singular_name ) . '</li>';
			}

			if ( is_single() ) {
				echo  "  /<li>";
				echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
				echo '</li>';
			}
		} elseif ( is_page() ) {
			echo '<li>';
			echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
			echo '</li>';
		}
	}
	if ( defined('LP_COURSE_CPT') && is_post_type_archive( LP_COURSE_CPT ) ) {
	  echo "<li>" . esc_html__(' Courses','turitor') . "</li>";	
	}

	if ( function_exists('tutor') ) {
		$course_post_type = tutor()->course_post_type;
		
		if ($course_post_type === 'courses' && is_post_type_archive('courses' )){
			echo "<li>" . esc_html__(' Courses','turitor') . "</li>";	
		}
	}


	if ( is_tag() ) {
		single_tag_title();
	} elseif ( is_day() ) {
		echo "<li>" . esc_html__( 'Blogs for', 'turitor' ) . " ";
		the_time( 'F jS, Y' );
		echo '</li>';
	} elseif ( is_month() ) {
		echo"<li>" . esc_html__( 'Blogs for', 'turitor' ) . " ";
		the_time( 'F, Y' );
		echo'</li>';
	} elseif ( is_year() ) {
		echo"<li>" . esc_html__( 'Blogs for', 'turitor' ) . " ";
		the_time( 'Y' );
		echo'</li>';
	} elseif ( is_author() ) {
		echo"<li>" . esc_html__( 'Author Blogs', 'turitor' );
		echo'</li>';
	} elseif ( isset( $_GET[ 'paged' ] ) && !empty( $_GET[ 'paged' ] ) ) {
		echo "<li>" . esc_html__( 'Blogs', 'turitor' );
		echo'</li>';
	} elseif ( is_search() ) {
		echo"<li>" . esc_html__( 'Search Result', 'turitor' );
		echo'</li>';
	} elseif ( is_404() ) {
		echo"<li>" . esc_html__( '404 Not Found', 'turitor' );
		echo'</li>';
	}
	echo '</ol>';
}


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function turitor_post_meta() {
?>
	<div class="post-meta">
		<?php 
			if ( get_post_type() === 'post') {
				printf(
					'<span class="post-author"><i class="tsicon tsicon-user"></i> <a href="%2$s">%3$s</a></span>',
					get_avatar( get_the_author_meta( 'ID' ), 55 ), 
					esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), 
					get_the_author()
				);
			}
			
			if ( get_post_type() === 'post') {
				echo '<span class="post-meta-date">
					<i class="fas fa-clock"></i>
						'. get_the_date() . 
					'</span>';
			} 
			if ( get_post_type() === 'turitor-events') {
				?>
				<span><i class="fa fa-calendar"></i><?php echo date('d M y ',strtotime( turitor_meta_option( get_the_ID(),'ts_event_date' ) ) );  ?>  </span> 
				<?php
					$time =  turitor_meta_option(get_the_ID(), 'ts_event_time');
				?>
				<span class="event-time event-time">
				<i class="fas fa-clock"></i>
						<?php echo esc_attr($time['from']); ?> -  <?php echo esc_attr($time['to']); ?>
				</span>
				<?php
			} 
			
			$category_list = get_the_category_list( ', ' );
			if ( $category_list ) {
				echo '<span class="meta-categories post-cat">
					<i class="fas fa-folder-open"></i>
						'. $category_list .' 
					</span>';
			}
			
		?>
	</div>
<?php }



// display meta date for a specific post
// ----------------------------------------------------------------------------------------
function turitor_post_meta_date() {
	if ( get_post_type() === 'post' ) {

		echo '<span class="post-meta-date meta-date">
				<span class="day">'. get_the_date( 'm' ) . '</span>
				'. get_the_date( 'M' ) . 
			 '</span>';
	}
}


// comment walker
// ----------------------------------------------------------------------------------------
function turitor_comment_style( $comment, $args, $depth ) {
	if ( 'div' === $args[ 'style' ] ) {
		$tag		 = 'div';
		$add_below	 = 'comment';
	} else {
		$tag		 = 'li ';
		$add_below	 = 'div-comment';
	}
	?>
	<?php
	if ( $args[ 'avatar_size' ] != 0 ) {
		echo get_avatar( $comment, $args[ 'avatar_size' ], '', '', array( 'class' => 'comment-avatar pull-left' ) );
	}
	?>
	<<?php
	echo turitor_kses( $tag );
	comment_class( empty( $args[ 'has_children' ] ) ? '' : 'parent'  );
	?> id="comment-<?php comment_ID() ?>"><?php if ( 'div' != $args[ 'style' ] ) { ?>
		<div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php }
	?>	
		<div class="meta-data">

			<div class="pull-right reply"><?php
				comment_reply_link(
				array_merge(
				$args, array(
					'add_below'	 => $add_below,
					'depth'		 => $depth,
					'max_depth'	 => $args[ 'max_depth' ]
				) ) );
				?>
			</div>


			<span class="comment-author vcard"><?php
				printf( turitor_kses( '<cite class="fn">%s</cite> <span class="says">%s</span>', 'turitor' ), get_comment_author_link(), esc_html__( 'says:', 'turitor' ) );
				?>
			</span>
			<?php if ( $comment->comment_approved == '0' ) { ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'turitor' ); ?></em><br/><?php }
			?>

			<div class="comment-meta commentmetadata comment-date">
				<?php
				// translators: 1: date, 2: time
				printf(
				esc_html__( '%1$s at %2$s', 'turitor' ), get_comment_date(), get_comment_time()
				);
				?>
				<?php edit_comment_link( esc_html__( '(Edit)', 'turitor' ), '  ', '' ); ?>
			</div>
		</div>	
		<div class="comment-content">
			<?php comment_text(); ?>
		</div>
		<?php if ( 'div' != $args[ 'style' ] ) : ?>
		</div><?php
	endif;
}


// pagination within pages or posts if it has a long content
// ----------------------------------------------------------------------------------------
function turitor_link_pages() {
	$args = array(
		'before'			 => '<div class="page-links"><span class="page-link-text">' . esc_html__( 'More pages: ', 'turitor' ) . '</span>',
		'after'				 => '</div>',
		'link_before'		 => '<span class="page-link">',
		'link_after'		 => '</span>',
		'next_or_number'	 => 'number',
		'separator'			 => '  ',
		'nextpagelink'		 => esc_html__( 'Next ', 'turitor' ) . '<I class="fas fa-angle-right"></i>',
		'previouspagelink'	 => '<I class="fas fa-angle-left"></i>' . esc_html__( ' Previous', 'turitor' ),
	);
	wp_link_pages( $args );
}


// learndash related course

	if ( ! function_exists( 'turitor_Learndash_related_courses' ) ) {
			function turitor_Learndash_related_courses() { ?>

			<h3 class="widget-title"><?php esc_html_e('You May Like Also', 'turitor'); ?></h3>
				<div class="turitor-related-course ld-related-course row">
					<?php
					$tags = wp_get_post_terms( get_queried_object_id(), 'ld_course_tag', ['fields' => 'ids'] );
					$args = [
					'post__not_in'        => array( get_queried_object_id() ),
					'posts_per_page'      => 3,
					'post_type'        => 'sfwd-courses',
					'ignore_sticky_posts' => 1,
					'orderby'             => 'rand',
					'tax_query' => [
						[
							'taxonomy' => 'ld_course_tag',
							'terms'    => $tags
						]
					]
				];

				$ld_query = new wp_query( $args );
				if( $ld_query->have_posts() ) {
					while( $ld_query->have_posts() ) {
						$ld_query->the_post();
						
							get_template_part('template-parts/blog/learndash/learndash', 'content'); 
						
						?>
				<?php } 
				wp_reset_postdata(); 
			} ?>
		</div>
		<?php
		}
	}

	

function get_activity_count_by_user( $user_id ) {
	$args = array(
        'per_page' => -1,
        'show_hidden' => true,
        'user_id' => $user_id
	);
	
	if ( bp_has_activities( $args ) ) {
        global $activities_template;
        $count = $activities_template->activity_count;
	} else {
	    $count = 0;
	}
	return $count;
}
