<?php
   $user = get_user_by( 'slug', get_query_var( 'user') );
   $profile      = LP_Profile::instance( $user->ID );
   $filter_status = LP_Request::get_string( 'filter-status' );
   $query         = $profile->query_courses( 'own', array( 'status' => $filter_status ) );
   $user          = $profile->get_user();
   $id            = $user->get_id();
   $custom_img    = $user->get_upload_profile_src();
   $gravatar_img  = $user->get_profile_picture( 'gravatar' );
   $thumb_size    = learn_press_get_avatar_thumb_size();

   $user_designation    = get_user_meta($id,'turitor_user_designation',true);
   $user_social_link    = get_user_meta($id,'user_social_link',true);
   $course_rating_data  = turitor_course_total_rating($query['items']);
   $total_rating        = $course_rating_data['sum'];
   if($total_rating > 0){
      $avarage_rating = number_format($total_rating/$course_rating_data['count'], 2);
   }else{
      $avarage_rating = 0; 
   }

   $following =  get_user_meta($id, 'turitor_following_instructors', true);
   $follower  =  get_user_meta($id, 'turitor_follower_instructors', true);


?>

<div class="insturctor-single main-container">
   <div class="container"> 
   
      <div class="row">
         <div class="col-lg-3">
            <div class="instructor-sidebar text-center">
               
               <div class="turitor-instructor-profile">
                     <?php if ( $custom_img ) { ?>
                           <img src="<?php echo esc_attr($custom_img); ?>"/>
                     <?php } else { ?>
                        <?php echo turitor_kses($gravatar_img); ?>
                     <?php } ?>
                  </div>
                  <h3 class="instructor-title ts-title">
                     <?php echo esc_html($user->get_display_name()); ?>
                  </h3>
                  <p class="instructor-designation">
                     <?php echo esc_html($user_designation); ?>
                  </p>
                  <ul class="instructor-follow">
                     <li class="follower">
                           <i class="tsicon tsicon-students"></i>
                           <?php $total_follower = is_array($follower)?count($follower):0; ?>
                           <?php $total_follower = ($total_follower > 0) ? $total_follower-1 : $total_follower; ?>
                           <?php echo esc_html__('Follower','turitor').' '.$total_follower; ?>
                     </li>
                     <li class="following"> 
                        <i class="tsicon tsicon-students"></i>
                        <?php $total_following = is_array($following)?count($following):0; ?>
                        <?php $total_following = ($total_following > 0) ? $total_following-1 : $total_following; ?>

                        <?php echo esc_html__('Following','turitor').' '.$total_following; ?>
                     </li>
                  </ul> 
                  <a data-user-id="<?php echo esc_attr($id); ?>" class="btn  btn-primary turitor-follow-instructor"> <i class="tsicon tsicon-plus_line"></i> <?php echo esc_html__('Follow','turitor'); ?> </a>

                  <ul class="ts-social">
                        <?php if(is_array($user_social_link)): ?>
                           <?php foreach($user_social_link as $social): ?>
                              <?php 
                               $str   = $social['icon'];
                               $class =  explode("-",$str);
                               $class = isset($class[1]) ? $class[1] : '';
                               $url   = isset($social['url']) ? $social['url'] : '';
                               $icon  = isset($social['icon']) ? $social['icon'] : '';
                              ?>
                              <li class="ts-<?php echo esc_attr($class); ?>">
                                  <a href="<?php echo esc_url( $url); ?>" >  <i class="<?php echo esc_attr( $icon); ?>" ></i> </a>
                              </li>
                           <?php endforeach; ?> 
                        <?php endif; ?>
                  </ul> 
            </div>
               
         </div>
         <div class="col-lg-9">
             <ul class="user-meta-summery row">
                  <li class="total-course col-md-4"> 
                        <h4><?php echo esc_html($query['total']); ?></h4>
                        <span><?php echo esc_html__('Courses Authored', 'turitor'); ?></span>
                  </li>
                  <li class="total-rating col-md-4">
                     <h4><?php echo esc_html($total_rating); ?></h4>
                     <span><?php echo esc_html__('Total Ratings', 'turitor'); ?></span>
                  </li>
                  <li class="avarage-rating col-md-4">
                     <h4><?php echo esc_html($avarage_rating); ?></h4>
                     <span><?php echo esc_html__('Avg Ratings', 'turitor'); ?></span>
                   </li>
               </ul> 

                <p class="user-bio">
                  <?php  
                     echo esc_html($user->get_description()); 
                  ?>
               </p>
          
               <div class="insturctor-course-list">
                  <h3 class="ts-title"> <?php echo esc_html__('Course by ','turitor').":".wp_kses_post($user->get_display_name()); ?> </h3> 
                  <?php  get_template_part("learnpress/profile/instructor",'course'); ?>
               </div>    
         </div> 
      </div>
   </div>
</div>