<?php

class HappyForms_Polls_Admin {

	private static $instance;

	/**
	 * The singleton constructor.
	 *
	 * @since 1.0
	 *
	 * @return HappyForms_Message_Admin
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		self::$instance->hook();

		return self::$instance;
	}

	public function hook() {
		$controller = happyforms_get_polls_controller();
		$form_post_type = happyforms_get_form_controller()->post_type;

		add_action( 'admin_head', array( $this, 'screen_title' ) );
		add_action( 'admin_head', array( $this, 'highlight_menu' ) );
		add_action( 'edit_form_after_title', array( $this, 'edit_screen' ) );
		add_action( 'add_meta_boxes', array( $this, 'setup_metaboxes' ) );

		add_action( "manage_{$form_post_type}_posts_custom_column", array( $this, 'forms_table_column_content' ), 20, 2 );
		add_filter( 'happyforms_manage_form_column_headers', array( $this, 'add_results_form_column' ) );
	}

	/**
	 * Action: customize the edit screen title.
	 *
	 * @since 1.0
	 *
	 * @hooked action admin_head
	 *
	 * @return void
	 */
	public function screen_title() {
		global $pagenow, $post, $title;

		$post_type = happyforms_get_polls_controller()->post_type;

		if ( 'post.php' === $pagenow && $post_type === get_post_type() ) {
			$poll_title = get_the_title( $post->ID );
			$poll_title = ( ! empty( $poll_title ) ) ? $poll_title : __( '(no label)', 'happyforms' );
			$title      = __( 'Results for', 'happyforms' ) . ' "' . $poll_title . '"';
		}
	}

	public function highlight_menu() {
		global $pagenow, $parent_file, $submenu_file, $submenu;
		
		$post_type = happyforms_get_polls_controller()->post_type;

		if ( 'post.php' === $pagenow && $post_type === get_post_type() ) {
			$parent_file = 'happyforms';
			$submenu_file = 'edit.php?post_type=happyforms-message';
		}
	}

	public function setup_metaboxes( $post_type ) {
		global $wp_meta_boxes;

		if ( 'happyforms-poll' === $post_type ) {
			// Clear standard metaboxes
			$wp_meta_boxes[$post_type] = array();

			add_meta_box(
				'happyforms-poll-details',
				__( 'Details' ),
				array( $this, 'metabox_poll_details' ),
				$post_type,
				'side',
				'high'
			);
		}
	}

	public function metabox_poll_details( $post, $metabox ) {
		global $form;

		$polls_controller = happyforms_get_polls_controller();
		$total_votes = $polls_controller->get_all_form_polls_votes( $form );
		?>
		<div class="misc-pub-section happyforms-message-form">
			<span>
				<i class="logo dashicons dashicons-format-status"></i> <?php _e( 'Form', 'happyforms' ); ?>: <a href="<?php echo happyforms_get_form_edit_link( $form['ID'] ); ?>"><?php echo esc_html( $form['post_title'] ); ?></a>
			</span>
		</div>
		<div class="misc-pub-section">
			<span>
				<i class="logo dashicons dashicons-chart-pie"></i> <?php echo $total_votes; ?> <?php echo happyforms_get_poll_votes_label( $total_votes ); ?>
			</span>
		</div>
		<?php do_action( 'happyforms_poll_metabox_details', $post->ID ); ?>
		<?php
	}

	public function edit_screen( $post ) {
		global $poll, $form;

		$polls_controller = happyforms_get_polls_controller();

		if ( $polls_controller->post_type === get_post_type( $post ) ) {
			$poll = happyforms_get_polls_controller()->get( $post->ID );
			$form = happyforms_get_form_controller()->get( $poll['form_id'] );

			require_once( happyforms_get_include_folder() . '/templates/admin-poll-edit.php' );
		}
	}

	public function add_results_form_column( $columns ) {
		$columns_before = $columns;
		$columns_after = $columns;

		$new_columns = array(
			'poll_results' => __( 'Results', 'happyforms' )
		);

		$columns_before = array_slice( $columns_before, 0, 4 );
		$columns_after = array_slice( $columns_after, 4 );

		$columns = array_merge( $columns_before, $new_columns, $columns_after );

		return $columns;
	}

	public function forms_table_column_content( $column, $id ) {
		switch( $column ) {
			case 'poll_results':
				$polls_controller = happyforms_get_polls_controller();
				$form_controller = happyforms_get_form_controller();
				$form = $form_controller->get( $id );

				$html = '—';

				if ( ! $form ) {
					echo $html;
					break;
				}

				$polls = $polls_controller->get_all_form_polls( $form );

				if ( $polls ) {
					$poll_votes = $polls_controller->get_all_form_polls_votes( $form );
					$first_poll = $polls_controller->get_poll_by_id( $form, $polls[0]['id'] );

					if ( $first_poll ) {
						$first_poll_id = $first_poll['ID'];
						$bubble_html = sprintf(
							'<span class="responses-count-read">%d</span>
							<span class="screen-reader-text">%d %s</span>',
							$poll_votes,
							$poll_votes,
							__( 'poll responses', 'happyforms' )
						);

						$link = sprintf(
							'<div class="happyforms-responses-count-wrapper">
								<span class="happyforms-responses-count happyforms-responses-count-read">%s</span>
							</div>',
							$bubble_html
						);

						if ( current_user_can( 'happyforms_manage_activity' ) ) {
							$link = sprintf(
								'<div class="happyforms-responses-count-wrapper">
									<a href="%s" class="happyforms-responses-count happyforms-responses-count-read">%s</a>
								</div>',
								admin_url( "/post.php?post={$first_poll_id}&action=edit"), $bubble_html
							);
						}

						$html = $link;
					}
				}

				echo $html;
				break;
		}
	}

}

/**
 * Initialize the HappyForms_Polls_Admin class immediately.
 */
HappyForms_Polls_Admin::instance();
