<?php if ( happyforms_is_preview() ) : ?>
	<div class="happyforms-block-editable happyforms-block-editable--partial happyforms-block-editable_happyforms-form-progress no-pencil" data-partial-id="form-progress-bar">
<?php endif; ?>
<div class="happyforms-form__progress happyforms-form-progress">
	<?php
	$form_controller = happyforms_get_form_controller();
	$breaks = $form_controller->get_parts_by_type( $form, 'page_break' );
	$breaks_count = count( $breaks );

	$item_max_width = 100 / $breaks_count;
	?>
	<ul class="happyforms-form-progress__steps">
		<?php foreach ( $breaks as $index => $break ) : ?>
			<?php
			$break_classes = array( 'happyforms-form-progress__step' );
			$break_classes[] = $break['css_class'];

			if ( 0 === $index ) {
				$break_classes[] = 'current';
			}
			?>
			<li class="<?php echo join( ' ', $break_classes ); ?>" id="happyforms-form-progress-step-<?php echo $break['id']; ?>" data-happyforms-step-id="<?php echo $break['id']; ?>" data-step="<?php echo $index; ?>">
				<div class="happyforms-form-progress__step-label">
					<span class="happyforms-form-progress__step-number"><?php echo $index + 1; ?><span class="happyforms-form-progress__step-fullstop">.</span></span>
					<span class="happyforms-form-progress__step-title"><?php echo $break['label']; ?></span>
				</div>
			</li>
		<?php endforeach; ?>
	</ul>
</div>
<?php if ( happyforms_is_preview() ) : ?>
	</div>
<?php endif; ?>