<script type="text/template" id="customize-happyforms-attachment-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p class="happyforms-placeholder-option">
		<label for="<%= instance.id %>_placeholder"><?php _e( 'Placeholder', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_placeholder" class="widefat title" value="<%= instance.placeholder %>" data-bind="placeholder" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Description', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_attachment_before_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'This is required', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_attachment_after_options' ); ?>

	<div class="happyforms-part-advanced-settings-wrap">
		<?php do_action( 'happyforms_part_customize_attachment_before_advanced_options' ); ?>

		<p>
			<label>
				<input type="checkbox" class="checkbox" value="1" <% if ( instance.use_max_file_count || instance.max_file_count ) { %>checked="checked"<% } %> data-bind="use_max_file_count" /> <?php _e( 'Limit files', 'happyforms' ); ?>
			</label>
		</p>
		<div class="happyforms-nested-settings" data-trigger="use_max_file_count" style="display: <%= ( 1 == instance.use_max_file_count || 0 != instance.max_file_count ) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_max_file_count"><?php _e( 'Max file count', 'happyforms' ); ?></label>
				<input type="number" min="1" max="20" id="<%= instance.id %>_max_file_count" class="widefat title" value="<%= instance.max_file_count %>" data-bind="max_file_count" />
			</p>
			<p>
				<label for="<%= instance.id %>_max_files_uploaded_label"><?php _e( '\'Max files uploaded\' label', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_max_files_uploaded_label" class="widefat title" value="<%= instance.max_files_uploaded_label %>" data-bind="max_files_uploaded_label" />
			</p>
		</div>

		<p>
			<label for="<%= instance.id %>_allowed_file_types"><?php _e( 'Allowed file types', 'happyforms' ); ?></label>
			<select id="<%= instance.id %>_allowed_file_types" name="allowed_file_types" data-bind="allowed_file_types" class="widefat">
				<option value=""<%= (instance.allowed_file_types == '') ? ' selected' : '' %>><?php _e( 'All', 'happyforms' ); ?></option>
				<option value="documents"<%= (instance.allowed_file_types == 'documents') ? ' selected' : '' %>><?php _e( 'Documents', 'happyforms' ); ?></option>
				<option value="archives"<%= (instance.allowed_file_types == 'archives') ? ' selected' : '' %>><?php _e( 'Archives', 'happyforms' ); ?></option>
				<option value="images"<%= (instance.allowed_file_types == 'images') ? ' selected' : '' %>><?php _e( 'Images', 'happyforms' ); ?></option>
				<option value="media"<%= (instance.allowed_file_types == 'media') ? ' selected' : '' %>><?php _e( 'Media', 'happyforms' ); ?></option>
				<option value="custom"<%= (instance.allowed_file_types == 'custom') ? ' selected' : '' %>><?php _e( 'Custom', 'happyforms' ); ?></option>
			</select>
		</p>
		<div class="happyforms-nested-settings" data-trigger="allowed_file_types:custom" style="display: <%= ( 'custom' === instance.allowed_file_types ) ? 'block' : 'none' %>">
			<p>
				<label for="<%= instance.id %>_allowed_file_extensions"><?php _e( 'Allowed file extensions', 'happyforms' ); ?></label>
				<input type="text" id="<%= instance.id %>_allowed_file_extensions" class="widefat title" value="<%= instance.allowed_file_extensions %>" data-bind="allowed_file_extensions" />
			</p>
			<p class="description">
				<span><i><?php _e( 'Separate each extension with a comma.', 'happyforms' ); ?></i></span>
				<span class="happyforms-file-extensions"><i><?php echo implode( ', ', happyforms_get_file_types() ); ?>.</i></span>
				<span class="happyforms-show-file-extensions">
					<a href="#"><?php _e( 'Show list of allowed extensions', 'happyforms' ); ?></a>.
				</span>
				<span class="happyforms-hide-file-extensions">
					<a href="#"><?php _e( 'Hide list of allowed extensions', 'happyforms' ); ?></a>.
				</span>
			</p>
		</div>
		<p>
			<label for="<%= instance.id %>_max_file_size"><?php _e( 'Max size per file (MB)', 'happyforms' ); ?></label>
			<input type="number" min="1" max="<?php echo floor( wp_max_upload_size() / 1048576 ); ?>" id="<%= instance.id %>_max_file_size" class="widefat title" value="<%= instance.max_file_size %>" data-bind="max_file_size" />
		</p>

		<?php happyforms_customize_part_width_control(); ?>

		<?php do_action( 'happyforms_part_customize_attachment_after_advanced_options' ); ?>

		<p>
			<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
		</p>
	</div>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
