<?php

class HappyForms_Service_Email extends HappyForms_Service {

	public $id = 'email';
	public $supports_multiple = false;
	public $active_service_option_name = '';
	public $active_service = false;

	public function __construct() {
		$this->label = __( 'Email', 'happyforms' );
		$this->active_service_option_name = "_happyforms_{$this->id}_service_active";
	}

	public function set_active_service( $service_id ) {
		update_option( $this->active_service_option_name, $service_id );
	}

	public function get_active_service() {
		$service = get_option( $this->active_service_option_name, false );

		if ( ! empty( $service ) ) {
			$service = happyforms_get_integrations()->get_service( $service );
		}

		return $service;
	}

	public function reset_active_service() {
		update_option( $this->active_service_option_name, '' );
	}

	public function configure() {
		$this->active_service = $this->get_active_service();
		$this->load();
	}

	public function load() {
		if ( ! $this->active_service ) {
			return;
		}

		require_once( happyforms_get_integrations_folder() . '/services/email/class-integration-email.php' );
		$this->active_service->load();
	}

}
