<?php
   namespace Elementor;
   
   if ( ! defined( 'ABSPATH' ) ) exit;

   class Turitor_Buddypress_Group_Widget extends Widget_Base {
   
   
      public $base;
   
      public function get_name() {
         return 'buddypress-group';
      }
   
      public function get_title() {
         return esc_html__( 'Buddypress Group', 'turitor' );
      }
   
      public function get_icon() { 
         return 'fas fa-users';
      }
   
      public function get_categories() {
         return [ 'turitor-elements' ];
      }
   
      protected function _register_controls() {
         $this->start_controls_section(
            'section_tab', [
               'label' => esc_html__( 'Latest Group', 'turitor' ),
            ]
         );
      
         $this->add_control(
         'group_count',
            [
               'label'         => esc_html__( 'Group count', 'turitor' ),
               'type'          => Controls_Manager::NUMBER,
               'default'       => '4',
            ]
         );
   
         $this->add_control(
            'group_style',
            [
               'label'   => esc_html__( 'Group Style', 'turitor' ),
               'type'    => Controls_Manager::SELECT,
               'default' => 'style1',
               'options' => [
                  'style1'  => esc_html__( 'Style 1 ', 'turitor' ),
               ],
            ]
         );
      
      $this->add_control(
         'post_col',
         [
            'label'   => esc_html__( 'Post Column', 'turitor' ),
            'type'    => Controls_Manager::SELECT,
            'default' => '4',
            'options' => [
               '3'  => esc_html__( '4 Column ', 'turitor' ),
               '4'  => esc_html__( '3 Column', 'turitor' ),
               '6'  => esc_html__( '2 Column', 'turitor' ),
            ],
         ]
      );

      $this->end_controls_section();
      
		$this->start_controls_section(
			'buddypress_group_style',
			[
				'label'	 => esc_html__('Group Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

      $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'overlay_color',
				'label' => esc_html__('Group Overlay BG Color', 'turitor'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .bp-single-item.bp-single-group::before',
			]
		);

      $this->end_controls_section();
   
   } 
   
    protected function render() {
      
      $settings        = $this->get_settings();

      $group_style = $settings['group_style'];
      $group_count = $settings['group_count'];
      $post_col = $settings['post_col'];

      include (locate_template("components/editor/elementor/widgets/style/buddypress/groups/{$group_style}.php", false, false ));  
   
    }
}