<?php
   namespace Elementor;
   
   if ( ! defined( 'ABSPATH' ) ) exit;

   class Turitor_Buddypress_notification_Widget extends Widget_Base {
   
   
      public $base;
   
      public function get_name() {
         return 'buddypress-notification';
      }
   
      public function get_title() {
         return esc_html__( 'Buddypress Notification', 'turitor' );
      }
   
      public function get_icon() { 
         return 'fas fa-bell';
      }
   
      public function get_categories() {
         return [ 'turitor-elements' ];
      }
   
      protected function _register_controls() {
         $this->start_controls_section(
            'section_tab', [
               'label' => esc_html__( 'Latest Notification', 'turitor' ),
            ]
         );
      
         $this->add_control(
            'bp_notification_icon',
            [
               'label' => esc_html__('Icon', 'turitor'),
               'type' => Controls_Manager::ICONS,
               'default' => [
                  'value' => 'fas fa-bell',
                  'library' => 'solid',
               ],
            ]
         );
   
   
      $this->end_controls_section();
      
		$this->start_controls_section(
			'buddypress_notification_style',
			[
				'label'	 => esc_html__('Notification Style', 'turitor'),
				'tab'	 => Controls_Manager::TAB_STYLE,
			]
		);

      $this->add_control(
			'bp_notify_icon_color',
			[
				'label'		 => esc_html__('Icon Color', 'turitor'),
				'type'		 => Controls_Manager::COLOR,
				'selectors'	 => [
					'{{WRAPPER}} .bp-notify a' => 'color: {{VALUE}};',
				],
			]
		);

      $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'		 => 'bp_notify_icon_typography',
            'label'      => esc_html__('Icon Typography', 'turitor'),
				'selector'	 => '{{WRAPPER}} .bp-notify a, {{WRAPPER}} .bp-notify a sup',
			]
		);

      $this->end_controls_section();
   
   } 
   
    protected function render() {
      
      $settings        = $this->get_settings();

      ?>
         <?php $user_id = get_current_user_id(); ?>
         <div class="bp-notify">
            <a class="notify-icon" href="#">
               <?php 
                  Icons_Manager::render_icon($settings['bp_notification_icon'], ['aria-hidden' => 'true']); 
               ?>
            </a>
            <?php if(is_user_logged_in()){ ?>
               <sup> <?php echo bp_notifications_get_unread_notification_count( $user_id ); ?> </sup>
            <?php } else { ?>
               <sup>0</sup>
            <?php } ?>
            
         </div>
      <?php
   
    }
}