<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Campus_Slider_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-campus-slider';
    }

    public function get_title() {

        return esc_html__( 'Turitor Campus slider', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }
    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Slider settings', 'turitor'),
            ]
        );
       
        $this->add_control(
			'style',
			[
				'label' => esc_html__( 'Slider Style', 'turitor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1', 'turitor' ),
					
				],
			]
         );

         $this->add_control(
			'count_show',
			[
				'label' => esc_html__( 'count', 'turitor' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 1,
			]
		);
   
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'slider_main_title', [
                'label' => esc_html__('#Title','turitor'),
                'type'         => Controls_Manager::TEXT,
                'default'      => esc_html__('title', 'turitor'),
                'label_block'  => true,
			]
		);

        $repeater->add_control(
			'slider_desc', [
                'label' => esc_html__('Slider caption','turitor'),
                'type'         => Controls_Manager::TEXTAREA,
                'default'      => esc_html__('We believe everyone has the ', 'turitor'),
                'label_block'  => true,
			]
		);
        $repeater->add_control(
			'slider_bg_image', [
                'label'       => esc_html__('Background Image', 'turitor'),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'separator'   => 'after',
			]
        );
        
        $this->add_control(
			'slider_items',
			[
				'label' => esc_html__( 'Service Slider', 'turitor' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
					[
						'slider_main_title' => esc_html__('Learn Anytime, Anywhere Accelerate ', 'turitor'),
					],
				],
				'title_field' => '{{{ slider_main_title }}}',
			]
		);
       
     
      $this->end_controls_section();

        //style
        $this->start_controls_section('style_section',
            [
               'label'    => esc_html__( 'Style Section', 'turitor' ),
               'tab'      => Controls_Manager::TAB_STYLE,
            ]
       ); 
     
          
       $this->add_control(
        'ts_slider_autoplay',
            [
            'label' => esc_html__( 'Autoplay', 'turitor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'turitor' ),
            'label_off' => esc_html__( 'No', 'turitor' ),
            'return_value' => 'yes',
            'default' => 'no'
            ]
        );

        $this->add_control(
			'ts_slider_speed',
            [
               'label' => esc_html__( 'Slider Speed', 'turitor' ),
               'type' => \Elementor\Controls_Manager::NUMBER,
               'placeholder' => esc_html__( 'Enter Slider Speed', 'turitor' ),
               'default' => 5000,
               'condition' => ["ts_slider_autoplay" => ['yes']],
            ]
		  );

        $this->add_control(
        'ts_slider_nav_show',
            [
            'label' => esc_html__( 'Nav show', 'turitor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'turitor' ),
            'label_off' => esc_html__( 'No', 'turitor' ),
            'return_value' => 'yes',
            'default' => 'yes'
            ]
        );
        $this->add_control(
         'ts_slider_dot_nav_show',
             [
             'label' => esc_html__( 'Dot nav', 'turitor' ),
             'type' => \Elementor\Controls_Manager::SWITCHER,
             'label_on' => esc_html__( 'Yes', 'turitor' ),
             'label_off' => esc_html__( 'No', 'turitor' ),
             'return_value' => 'yes',
             'default' => 'yes'
             ]
         );

        $this->end_controls_section();

        $this->start_controls_section('title_style_section',
         [
            'label'    => esc_html__( 'Slider Content ', 'turitor' ),
            'tab'      => Controls_Manager::TAB_STYLE,
         ]
       );

    
        $this->add_control('slider_desc_color',
        [
            'label'     => esc_html__('Desc color', 'turitor'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .campus-slider .owl-stage .owl-item .item .single-service .service-info-content p' => 'color: {{VALUE}};',
            ],
        ]
       ); 

       
       $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'desc_typography',
            'label' => esc_html__( 'Desc typography', 'turitor' ),
            
            'selector' => '{{WRAPPER}} .campus-slider .owl-stage .owl-item .item .single-service .service-info-content p',
        ]
      );
  
     
    $this->end_controls_section();  

    $this->start_controls_section('nav_style_section',
        [
        'label'    => esc_html__( 'Nav ', 'turitor' ),
        'tab'      => Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control('slider_nav_color',
    [
        'label'     => esc_html__('hover Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-next' => 'color: {{VALUE}};',
        ],
    ]
    ); 

    $this->add_control('slider_nav_bgcolor',
    [
        'label'     => esc_html__(' hover bg Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-prev,.service-slider .owl-nav .owl-next' => 'background-color: {{VALUE}};border-color:{{VALUE}} ',
        ],
    ]
    ); 

    $this->add_control('slider_nav_hvcolor',
    [
        'label'     => esc_html__('hover Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-next:hover' => 'color: {{VALUE}};',
        ],
    ]
    ); 

    $this->add_control('slider_nav_hvbgcolor',
    [
        'label'     => esc_html__(' hover bg Color', 'turitor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
            '{{WRAPPER}} .service-slider .owl-nav .owl-prev:hover,.service-slider .owl-nav .owl-next:hover' => 'background-color: {{VALUE}}; border-color:{{VALUE}}',
        ],
    ]
    ); 

    $this->end_controls_section(); 

    
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $slider_items = $settings['slider_items'];
       
        $show_navigation   =   $settings["ts_slider_nav_show"]=="yes"?true:false;
        $auto_nav_slide    =   $settings['ts_slider_autoplay'];
        $dot_nav_show      =   $settings['ts_slider_dot_nav_show'];
        $ts_slider_speed   =   $settings['ts_slider_speed'];
        $count_show   =   $settings['count_show'];

        $slide_controls    = [
         'show_nav'=>$show_navigation, 
         'dot_nav_show'=>$dot_nav_show, 
         'auto_nav_slide'=>$auto_nav_slide, 
         'ts_slider_speed'=>$ts_slider_speed, 
         'count_show'=>$count_show, 
        ];
   
        $slide_controls = \json_encode($slide_controls); 

        if($settings['style']=='style1'):   
            include (locate_template("components/editor/elementor/widgets/style/campus-slider/default.php", false, false ));  
        endif;
        
    ?>
    
    <?php  
    }
    protected function _content_template() { }
}