<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Event_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-event';
    }

    public function get_title() {
        return esc_html__( 'Events', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

	protected function _register_controls() {
		$this->start_controls_section(
			'section_tab', [
				'label' => esc_html__( 'Latest event', 'turitor' ),
			]
        );
      
      $this->add_control(
         'post_count',
                     [
                        'label'         => esc_html__( 'Post count', 'turitor' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => '3',

                     ]
      );

      $this->add_control(
			'event_style',
			[
				'label'   => esc_html__( 'Event style', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1 ', 'turitor' ),
					'style2'  => esc_html__( 'Style 2', 'turitor' ),
					'style3'  => esc_html__( 'Style 3', 'turitor' ),
				
			
				],
			]
      );
      
      $this->add_control(
			'post_col',
			[
				'label'   => esc_html__( 'Post Column', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
            'condition' => ["event_style" => ['style2', 'style3']],
				'default' => '3',
				'options' => [
					'3'  => esc_html__( '4 Column ', 'turitor' ),
					'4'  => esc_html__( '3 Column', 'turitor' ),
					'6'  => esc_html__( '2 Column', 'turitor' ),
			
				],
			]
		);

      $this->add_control('post_category',
         [
            'label'     => esc_html__( 'Category', 'turitor' ),
            'type'      => \Elementor\Controls_Manager::SELECT2,
            'multiple'  => true,
            'default'   => [],
            'options'   => $this->getCategories(),
         
         ]
      ); 


      $this->add_control(
         'post_title_crop',
         [
           'label'         => esc_html__( 'Title limit', 'turitor' ),
           'type'          => Controls_Manager::NUMBER,
           'default'       => '3',
           
         ]
       ); 

       $this->add_control(
         'post_sort_by',
         [
            'label' => esc_html__( 'Sort By', 'turitor' ),
            'type' => Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
                    'ASC'  => esc_html__( 'ASC', 'turitor' ),
                    'DESC'  => esc_html__( 'DESC', 'turitor' ),
                ],
               
         ]
      );

      $this->add_control(
         'hide_event',
         [
            'label'     => esc_html__( 'Hide Event', 'turitor' ),
            'type'      => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'options'   => $this->getEvent(),
          ]
      ); 
       
      $this->add_control(
         'show_desc',
         [
             'label'     => esc_html__('Show description', 'turitor'),
             'type'      => Controls_Manager::SWITCHER,
             'label_on'  => esc_html__('Yes', 'turitor'),
             'label_off' => esc_html__('No', 'turitor'),
             'default'   => 'yes',
            
         ]
      ); 
      $this->add_control('desc_limit',
            [
              'label'         => esc_html__( 'Description limit', 'turitor' ),
              'type'          => Controls_Manager::NUMBER,
              'default'       => '10',
              'condition'     => [ 
                 'show_desc' => ['yes'] 
               ],
              
            ]
      );   
    
      $this->add_control('show_cat',
            [
                'label'     => esc_html__('Show category', 'turitor'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'turitor'),
                'label_off' => esc_html__('No', 'turitor'),
                'default'   => 'yes',
            ]
        );

        $this->add_control('show_event_time',
        [
            'label'     => esc_html__('Show Event Time', 'turitor'),
            'type'      => Controls_Manager::SWITCHER,
            'label_on'  => esc_html__('Yes', 'turitor'),
            'label_off' => esc_html__('No', 'turitor'),
            'default'   => 'yes',
        ]
    );

      $this->add_control('show_date',
        [
            'label'     => esc_html__('Show Date', 'turitor'),
            'type'      => Controls_Manager::SWITCHER,
            'label_on'  => esc_html__('Yes', 'turitor'),
            'label_off' => esc_html__('No', 'turitor'),
            'default'   => 'yes',
        ]
     ); 

      $this->add_control(
         'show_author',
               [
                  'label'     => esc_html__('Show Author', 'turitor'),
                  'type'      => Controls_Manager::SWITCHER,
                  'label_on'  => esc_html__('Yes', 'turitor'),
                  'label_off' => esc_html__('No', 'turitor'),
                  'default'   => 'no',
         
               ]
         );

      $this->add_control('show_readmore',
                  [
                     'label'     => esc_html__('Show Readmore', 'turitor'),
                     'type'      => Controls_Manager::SWITCHER,
                     'label_on'  => esc_html__('Yes', 'turitor'),
                     'label_off' => esc_html__('No', 'turitor'),
                     'default'   => 'yes',
            
                  ]
            );   

       
      $this->end_controls_section();
      
      $this->start_controls_section('style_title_section',
			[
				'label' => esc_html__( 'Title', 'turitor' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
      ); 
      
      $this->add_control(
         'post_text_color',
         [
             'label' => esc_html__('Title color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .turitor-events .entry-header .entry-title a' => 'color: {{VALUE}};',
             ],
         ]
        );

      $this->add_control(
         'post_text_color_hover',
            [
               'label'     => esc_html__('Title hover', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                  '{{WRAPPER}} .turitor-events .entry-header .entry-title a:hover' => 'color: {{VALUE}};',
            
               ],
            ]
        );

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'title_typography',
            'selector'	 => '{{WRAPPER}} .entry-header .entry-title',
          ]
      );

      $this->add_responsive_control(
         'title_margin',
         [
             'label' => esc_html__( 'Title Margin', 'turitor' ),
             'type' => Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', '%', 'em' ],
             'selectors' => [
                 '{{WRAPPER}} .entry-header .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
             ],
         ]
         );
     
      $this->end_controls_section();
     
      $this->start_controls_section('style_content_section',
         [
            'label' => esc_html__( 'Content', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition'     => [ 
               'show_desc' => ['yes'] 
             ],
         ]
      ); 
      
      $this->add_control(
         'post_content_color',
         [
             'label' => esc_html__('Content color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .turitor-events p' => 'color: {{VALUE}};',
             ],
         ]
        );

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'content_typography',
         'selector'	 => '{{WRAPPER}} .turitor-events p',
         ]
      );
      
      $this->end_controls_section();  

      $this->start_controls_section('style_readmore_section',
         [
            'label' => esc_html__( 'Readmore', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
            
         ]
      ); 

      $this->add_control(
         'post_readmore_color',
         [
             'label' => esc_html__('Readmore color', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .turitor-events .post-footer a ' => 'color: {{VALUE}};',
             ],
         ]
        );

        $this->add_control(
         'post_readmore_color_hover',
         [
             'label' => esc_html__('Readmore hover', 'turitor'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'selectors' => [
                  '{{WRAPPER}} .turitor-events.post-footer a:hover' => 'color: {{VALUE}};',
             ],
         ]
        );

        $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'readmore_typography',
         'selector'	 => '{{WRAPPER}} .turitor-events .post-footer a',
         ]
      );

      $this->end_controls_section();
      
      
      $this->start_controls_section('style_meta_section',
         [
            'label' => esc_html__( 'Meta', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
         ]
      ); 

      
   
   $this->add_control(
      'date_color',
      [
          'label' => esc_html__('Date color', 'turitor'),
          'type' => Controls_Manager::COLOR,
          'default' => '',
          'selectors' => [
               '{{WRAPPER}} .turitor-events .event-date span' => 'color: {{VALUE}};',
          ],
      ]
     );
     $this->add_group_control(
      Group_Control_Typography::get_type(), [
      'name'		 => 'day_typography',
      'label' => esc_html__('Day Typography color', 'turitor'),

      'selector'	 => '{{WRAPPER}} .turitor-events .event-date .day',
      ]
   );
     $this->add_group_control(
      Group_Control_Typography::get_type(), [
      'name'		 => 'month_typography',
      'label' => esc_html__('Month Typography color', 'turitor'),

      'selector'	 => '{{WRAPPER}} .turitor-events .event-date .month',
      ]
   );
   
      $this->add_control(
         'post_meta_cat_color',
            [
               'label'     => esc_html__('Category Color', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                  '{{WRAPPER}} .turitor-events .entry-header .event-meta-cat a' => 'color: {{VALUE}};',
            
               ],
            ]
      );
      $this->add_control(
         'post_meta_color_hover',
            [
               'label'     => esc_html__('Category hover', 'turitor'),
               'type'      => Controls_Manager::COLOR,
               'default'   => '',
               'selectors' => [
                  '{{WRAPPER}} .turitor-events .entry-header .event-meta-cat a:hover' => 'color: {{VALUE}};',
                  '{{WRAPPER}} .turitor-events .entry-header .event-meta-cat a:before' => 'background: {{VALUE}};',
            
               ],
            ]
      );

      $this->add_control(
			'event_time_meta_color',
			[
				'label' => esc_html__( 'Event Time Meta Color', 'turitor' ),
				'type' =>Controls_Manager::COLOR,
				// 'scheme' => [
				// 	'type' => Scheme_Color::get_type(),
				// 	'value' => Scheme_Color::COLOR_1,
				// ],
				'selectors' => [
					'{{WRAPPER}} .turitor-events .entry-header .event-time:before' => 'background: {{VALUE}}',
				],
			]
		);

      $this->add_group_control(
         Group_Control_Typography::get_type(), [
         'name'		 => 'meta_typography',
         'selector'	 => '{{WRAPPER}} .turitor-events .entry-header .event-meta-cat a',
         ]
      );
   
      $this->end_controls_section();

      $this->start_controls_section('event_style_padding',
         [
            'label' => esc_html__( 'Additional', 'turitor' ),
            'tab' => Controls_Manager::TAB_STYLE,
         ]
      ); 

      $this->add_responsive_control(
         'event_padding',
         [
             'label' => esc_html__( 'Event Padding', 'turitor' ),
             'type' => Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', '%', 'em' ],
             'selectors' => [
                 '{{WRAPPER}} .turitor-events .event-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
             ],
         ]
         );

      $this->end_controls_section();


    } 

    protected function render() {
     
    $settings        = $this->get_settings();
    $post_title_crop = $settings["post_title_crop"];
    $show_desc       = $settings["show_desc"];
    $desc_limit      = $settings["desc_limit"];
    $post_count      = $settings["post_count"];
    $show_date       = $settings["show_date"];
    $show_cat        = $settings["show_cat"];
    $post_col        = $settings["post_col"];
    $show_event_time        = $settings["show_event_time"];
    $show_author     = $settings["show_author"];
    $show_readmore   = $settings["show_readmore"];
    $post_sort_by    = $settings["post_sort_by"];
    $post_category   = $settings["post_category"];
    $event_style   = $settings["event_style"];

    $hide_event   = $settings['hide_event'];
     
    $args = array(
        'numberposts'      => $post_count,
        'orderby'          => 'post_date',
        'order'            => $post_sort_by,
        'post_type'        => 'turitor-events',
        'post_status'      => 'publish',
        'post__not_in'     =>$hide_event,
       
    );
    if(is_array($post_category) && count($post_category))
     {
      $args['tax_query']  = 
      [
         array(
          'taxonomy'  => 'ts-event-category',
          'field'     => 'term_id',
          'terms'     => $post_category,
          'operator'  => 'IN',
         )
      ];
     }
  
     
   $recent_posts = get_posts( $args );


    if($event_style=='style1'){
      include (locate_template("components/editor/elementor/widgets/style/events/default.php", false, false ));  
    }

    if($event_style=='style2'){
  
      include (locate_template("components/editor/elementor/widgets/style/events/style2.php", false, false ));  
    }

    if($event_style=='style3'){
  
      include (locate_template("components/editor/elementor/widgets/style/events/style3.php", false, false ));  
    }


    }

    public function getCategories(){
      
      $terms = get_terms( array(
                  'taxonomy'    => 'ts-event-category',
                  'hide_empty'  => false,
                  'posts_per_page' => -1, 
          ) );

      
      $cat_list = [];
    
      foreach($terms as $post) {
     
          $cat_list[$post->term_id]  = [$post->name];
      }
      
      return $cat_list;

  } 

  public function getEvent(){
         
      $event_list = [];
      $args = array(
         'numberposts'      => -1,
         'orderby'          => 'post_date',
         'order'            => 'DESC',
         'post_type'        => 'turitor-events',
         'post_status'      => 'publish',
         'suppress_filters' => true
      );
      $event = get_posts($args);

      if($event):
      // Loop the posts
         foreach ($event as $eventlist):
         $event_list[$eventlist->ID]= $eventlist->post_title; 
         endforeach;
      endif;
      return $event_list;
   }
}