<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Tutor_Instructor_Widget extends Widget_Base {


    public $base;

    public function get_name() {
        return 'tutor-instructor';
    }

    public function get_title() {
        return esc_html__( 'tutor Instructors', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-person';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {
      $this->start_controls_section(
        'section_tab',
        [
          'label' => esc_html__( 'Instructor', 'turitor' ),
          'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
	  );
	  $this->add_control(
		'instructor_style',
		  [
			'label' => esc_html__( 'Instructor Style', 'turitor' ),
			'type' => Controls_Manager::SELECT,
			'default' => 'instructor-1',
			'options' => [
			  'instructor-1'  => esc_html__( 'Instructor Style 1', 'turitor' ),
		  
			],
		  ]
	  );

	  $this->add_control(
		'post_col',
		[
			'label'   => esc_html__( 'Post Column', 'turitor' ),
			'type'    => Controls_Manager::SELECT,
			'default' => '3',
			'options' => [
				'3'  => esc_html__( '4 Column ', 'turitor' ),
				'4'  => esc_html__( '3 Column', 'turitor' ),
		
			],
		]
	);
	$repeater = new \Elementor\Repeater();
  
	$repeater->add_control(
		'instructor_ids', [
			'label'        => esc_html__('Instructor List', 'turitor'),
			'type'         => Controls_Manager::SELECT,
			'options' => $this->instructor_list(),
			'label_block'  => true,
		]
	);

	$repeater->add_control(
		'title', [
			'label'			=> esc_html__( 'Title', 'turitor' ),
			'type'			=> Controls_Manager::TEXT,
			'label_block'	=> true,
		]
	);

	$this->add_control(
		'instructor_carousel',
		[
			'label' => esc_html__('Instuctor List', 'turitor'),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[
					'title' => esc_html__('Instructor Item #1', 'turitor')
				],
			],
			'title_field' => '{{{ title }}}',
		]
	);
	 
	$this->end_controls_section();

  	  //Content style
		 $this->start_controls_section('Content_section',
			[
				'label'    => esc_html__( 'Content Section', 'turitor' ),
				'tab'      => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control('title_color',
			[
				'label'     => esc_html__('Title color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .single-instructor-item .instructor-name a' => 'color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_control('title_hover_color',
			[
				'label'     => esc_html__('Title hover color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .hover-item .instructor-name a' => 'color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( ' Typography', 'turitor' ),
				
				'selector' => '{{WRAPPER}} .single-instructor-item .instructor-name',
			]
		  );
		  
		$this->add_control('designation_color',
			[
				'label'     => esc_html__('Designation color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .instructor-list-wrap .single-instructor-item p' => 'color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_control('Designation_hover_color',
			[
				'label'     => esc_html__('Designation hover color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .hover-item .instructor-designation' => 'color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Designation_typography',
				'label' => esc_html__( ' Designation Typography', 'turitor' ),
				
				'selector' => '{{WRAPPER}} .instructor-list-wrap .single-instructor-item p',
			]
        );

  		$this->end_controls_section();
  	  //Image style
		 $this->start_controls_section('img_section',
		 [
					'label'    => esc_html__( 'Image Section', 'turitor' ),
					'tab'      => Controls_Manager::TAB_STYLE,
				]
		);
		$this->add_control('Image_bg_color',
			[
				'label'     => esc_html__('Image BG color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .instructor-profile-pic.round' => 'background-color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_control('Image_bg_hover_color',
			[
				'label'     => esc_html__('Image BG hover color', 'turitor'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
						'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .hover-item' => 'background-color: {{VALUE}};',
				
					],
			]
		); 
		$this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Image width', 'turitor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 600,
						'step' => 1,
					],
					
				],
				'default' => [
					'unit' => 'px',
					'size' => 255,
				],
				'selectors' => [
					'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .instructor-profile-pic.round' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
      );

      $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Image height', 'turitor' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 600,
						'step' => 1,
					],
					
				],
				'default' => [
					'unit' => 'px',
					'size' => 255,
				],
				'selectors' => [
					'{{WRAPPER}} .instructor-list-wrap .single-instructor-item .instructor-profile-pic.round' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		


  		$this->end_controls_section();

		  //slider style
        $this->start_controls_section('slider_section',
            [
               'label'    => esc_html__( 'Style Section', 'turitor' ),
               'tab'      => Controls_Manager::TAB_STYLE,
            ]
	   ); 
	   
	   $this->add_group_control(
		Group_Control_Background::get_type(),
		[
			'name' => 'background',
			'label' => __( 'Hover Background Overlay', 'turitor' ),
			'types' => [ 'classic', 'gradient', 'video' ],
			'selector' => '{{WRAPPER}} .instructor-list-wrap .single-instructor-item .hover-item .insturctor-img-area:before',
		]
	);
     
     

        $this->end_controls_section();
        
    }    
    protected function render() {
   
	  $settings   = $this->get_settings();
	  $instructor_style    =   $settings['instructor_style'];
	  $post_col   =   $settings['post_col'];





	  
	  $instructor_carousel = $settings['instructor_carousel'];
   

		if( $instructor_style == 'instructor-1'){
			include (locate_template("components/editor/elementor/widgets/style/instructors/tutor-instructor.php", false, false ));  
		}
		
     

    }

    public function instructor_list(){

        $instructor_list = [];
        $instructors = get_users( 'orderby=nicename&role=tutor_instructor' );
         foreach ($instructors as $postdata) {
            setup_postdata( $postdata );
            $instructor_list[$postdata->ID] = [$postdata->display_name];
         
         }
      
        return $instructor_list;
    }

}