<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class turitor_masonary_gallery_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-masonary-gallery';
    }

    public function get_title() {

        return esc_html__( 'masonary gallery', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('gallery settings', 'turitor'),
            ]
        );
        $this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'grid1'       => esc_html__( 'Grid style 1', 'turitor' ),
					
				],
				'default' => 'grid'
			]
      );
      
        $this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Images', 'turitor' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);

        $this->end_controls_section();

        

     
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $settings = $this->get_settings_for_display();
        $layout = $settings['layout'];

?>

   <?php if($layout == 'grid1'){ ?>
    <div class="ts-masonry">
      <?php
        foreach ( $settings['gallery'] as $image ) {
           ?>
            <div class="ts-masonary-item">
               <a href="<?php echo esc_url( $image['url']); ?>" class="ts-gallery-popup">
                  <img src="<?php echo esc_url($image['url'] ); ?>" alt="<?php echo esc_attr__('gallery', 'turitor'); ?>">
                  <span class="fas fa-plus"></span>
               </a>
            </div>
            <?php
         }

      ?>
    </div>

   <?php } ?>


    <?php  
    }

    protected function _content_template() {
   
     }
}