<?php

global $post, $wpdb;
$course_list = $turitor_course_settings['course_list'] ? $turitor_course_settings['course_list'] : array();
$limit      = $turitor_course_settings['limit'];
$thumb_w    = ( ! empty( $turitor_course_settings['thumbnail_width'] ) && '' != $turitor_course_settings['thumbnail_width'] ) ? $turitor_course_settings['thumbnail_width'] : apply_filters( 'thim_course_thumbnail_width', 450 );
$thumb_h    = ( ! empty( $turitor_course_settings['thumbnail_height'] ) && '' != $turitor_course_settings['thumbnail_height'] ) ? $turitor_course_settings['thumbnail_height'] : apply_filters( 'thim_course_thumbnail_height', 400 );


$condition = array(
	'post_type'           => 'lp_course',
	'post__in'            => array($course_list),
	
);


$the_query = new WP_Query( $condition );

	

if ( $the_query->have_posts() ) :
	?>
	  <div class="course-single-wrap" >
			<?php
				while ( $the_query->have_posts() ) : $the_query->the_post();
				$terms = get_the_terms( $post->ID, 'course_category' );
				$cat = '';
				$cat_with_link = '';
				
					if(is_array($terms)):

						foreach($terms as $tkey=>$term):
					     	
						  $cat.= $term->slug.' ';
						

						endforeach;

					endif; 
					$cat_with_link = turitor_course_cageory_by_id($post->ID);

				   $course    = LP()->global['course'];
				   
				    $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;
					$students_enrolled = $course->get_users_enrolled();
					$instructor = $course->get_instructor();
					$instructor_link = $course->get_instructor_html();
					$instructor_id = $course->get_id();
					$meta = get_post_meta( $post->ID );
									
					$featured = isset($meta['_lp_featured'][0]) ? $meta['_lp_featured'][0] : '';
								  
				  ?>
						<div class="single-course">
							<div class="course-thumbnail">
									<?php $course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' ); ?>
										<?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
												<img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo esc_html($post->post_title); ?>">
										<?php }else{ ?>
											<img class="img-fluid"  src="<?php echo esc_url(get_the_post_thumbnail_url( $post->ID, 'large' )); ?>" alt="<?php echo esc_html($post->post_title); ?>">
									<?php } ?>
							</div>
					


							<div class="course-price-item">
									<?php if($course->is_free()): ?>
									<span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
									<?php else: ?>
									<span class="course-price">							
									<?php echo turitor_kses($course->get_price_html()); ?>
									</span>
									<?php endif; ?>
								</div>

							<div class="course-category">
									<?php 
									echo wp_kses_post($cat_with_link);
									?> 
							</div>
							<h3 class="ts-course-el-title"> 
								<a href="<?php echo esc_url($course->get_permalink()); ?>">
									<?php echo esc_html($post->post_title); ?> 
								</a>	
							</h3>
							<div class="enrol-list-area">
								<ul class="course-enrole-list">
									<li class="lessons">
										<i class="tsicon tsicon-file"></i> 
										<?php echo esc_html($lessons); ?>
										<?php echo esc_html__(' Lessons', 'turitor'); ?>
									</li>
									<li class="students">
											<i class="tsicon tsicon-user_group"></i> 
											<?php echo esc_html($course->count_students()); ?> 
									</li>
								</ul>
							</div>
							<div class="border-bar"></div>
							<div class="course-footer">
								<?php 
								if(defined('WUR_REVIEW_KEY')) {
									echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '' ]);
								}
								?>

								<a href="<?php echo esc_url($course->get_permalink()); ?>" class="btn-link"><i class="tsicon tsicon-right_arrow"></i></a>
						
							</div>
						</div>
				  <?php
				  
				endwhile;
			?>
	 </div>
	<?php
endif;



