<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_Tab extends Widget_Base {


    public $base;

    public function get_name() {
        return 'turitor-tab';
    }

    public function get_title() {
        return esc_html__( 'Turitor Tab', 'turitor' );
    }

    public function get_icon() { 
        return 'eicon-gallery-group';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Tab Settings', 'turitor'),
            ]
        );
        $this->add_responsive_control(
            'turitor_tabs_align',
            [
                'label' =>esc_html__( 'Nav Alignment', 'turitor' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' =>esc_html__( 'Left', 'turitor' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' =>esc_html__( 'Center', 'turitor' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' =>esc_html__( 'Right', 'turitor' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .turitor-tab ul .tab-list' => 'text-align: {{VALUE}};'
                ],
                'default' => 'left',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'turitor_nav_title', [
                'label' => esc_html__('Nav Title', 'turitor'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__(' Our History ', 'turitor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'turitor_nav_sub_title', [
                'label' => esc_html__('Nav Sub Title', 'turitor'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__(' Explore the history of Turitor University ', 'turitor'),
                'label_block' => true
            ]
        );

        $repeater->add_control(
            'turitor_tab_title_icons', [
                'label' => esc_html__('Title Icon', 'turitor'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'fa fa-clock-o',
                ]
            ]
        );

       $repeater->add_control(
            'turitor_tab_content', [
                'label' => esc_html__('Tab Content', 'turitor'),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true
            ]
        );
       $repeater->add_control(
            'tab_bg', [
                'label' => esc_html__('Choose Background Image', 'turitor'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true
            ]
        );
   

        $this->add_control(
            'turitor_tab_items',
            [
                'label' => esc_html__('Tab content', 'turitor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'turitor_nav_title' =>  esc_html__( 'Our History', 'turitor' ),
                        'turitor_nav_sub_title' => esc_html__( 'Explore the history of Turitor University', 'turitor' ),
                        'turitor_tab_content' =>  esc_html__( 'We accept applications for the fall semester from August through January (through March for transfer applicants) for undergraduate admission to our School of Arts and Sciences and/or our School of Engineering.', 'turitor' ),
                    ],
                    [
                        'turitor_nav_title' =>  esc_html__( 'Admissions & Aid', 'turitor' ),
                        'turitor_nav_sub_title' => esc_html__( 'Connect. Apply. Enroll. ', 'turitor' ),
                        'turitor_tab_content' =>  esc_html__( 'Our faculty and students study, teach, and learn in and across more than 180 programs regularly recognized as being among the nation’s best. All nine of our academic divisions offer full-time graduate programs.', 'turitor' ),
                    ],
                ]
            ]
        );
       
	$this->end_controls_section();

	$this->start_controls_section(
		'turitor_tab_style', [
			'label'	 => esc_html__( 'Nav Tabs Style', 'turitor' ),
			'tab'	 => Controls_Manager::TAB_STYLE,
		]
    );

    $this->add_control(
		'tab_icon_color', [
			'label'		 => esc_html__( 'Icon Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .title-icon' => 'color: {{VALUE}};',
			],
		]
    );

    $this->add_control(
		'tab_nav_title_color', [
			'label'		 => esc_html__( 'Navs Title Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content strong' => 'color: {{VALUE}};',
			],
		]
    );
    
    $this->add_control(
		'tab_nav_shape_color', [
			'label'		 => esc_html__( 'Title Shape Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content::before' => 'background: {{VALUE}};',
			],
		]
    );
    
    $this->add_group_control(
		Group_Control_Typography::get_type(), [
			'name'		 => 'tab_nav_title_typo',
			'selector'	 => '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content strong',
		]
    );

    $this->add_responsive_control(
        'tab_nav_title_margin',
        [
            'label' => esc_html__( 'Navs Tilte margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content strong' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

    $this->add_control(
		'tab_nav_subtitle_color', [
			'label'		 => esc_html__( 'Sub Title Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content span' => 'color: {{VALUE}};',
			],
		]
	);

    $this->add_group_control(
		Group_Control_Typography::get_type(), [
			'name'		 => 'tab_nav_subtitle_typo',
			'selector'	 => '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content span',
		]
    );

    $this->add_responsive_control(
        'tab_nav_subtitle_margin',
        [
            'label' => esc_html__( 'Sub Tilte margin', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    
      
    $this->add_responsive_control(
        'tab_title_content_padding',
        [
            'label' => esc_html__( 'Tilte Content Padding', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );


    $this->start_controls_tabs( 'turitor_tabs_styled' );

    $this->start_controls_tab(
        'tab_style_normal',
        [
            'label' => esc_html__( 'Nav Normal', 'turitor' ),
        ]
    );

    
    $this->add_control(
		'tab_nav_bg_color', [
			'label'		 => esc_html__( 'Tab BG Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a' => 'background: {{VALUE}};',
			],
		]
	);

    $this->add_group_control(
        Group_Control_Border::get_type(),
        [
            'name' => 'turitor_tab_border',
            'label' => esc_html__( 'Title Border', 'turitor' ),
            'selector' => '{{WRAPPER}} .turitor-tab .turitor-navs-tab li a .title-content .content',
        ]
    );


   
    $this->end_controls_tab();

    $this->start_controls_tab(
        'tab_style_active',
            [
                'label' =>esc_html__( 'Active', 'turitor' ),
            ]
    );

    $this->add_control(
		'tab_nav_active_bg_color', [
			'label'		 => esc_html__( 'Tab Active BG Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .turitor-navs-tab li a.active' => 'background: {{VALUE}};',
			],
		]
	);

    $this->add_group_control(
        Group_Control_Border::get_type(),
        [
            'name' => 'turitor_tab_active_border',
            'label' => esc_html__( 'Border', 'turitor' ),
            'selector' => '{{WRAPPER}} .turitor-tab .turitor-navs-tab li:not(:last-child) .title-content .content',
        ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();  
    
    $this->start_controls_section(
		'turitor_tab_content_style', [
			'label'	 => esc_html__( 'Content Style', 'turitor' ),
			'tab'	 => Controls_Manager::TAB_STYLE,
		]
    );

    $this->add_control(
		'tab_content_bg', [
			'label'		 => esc_html__( 'Content BG Color', 'turitor' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .turitor-tab .ts-tab-content' => 'background: {{VALUE}};',
			],
		]
	);

    $this->add_responsive_control(
        'tab_content_padding',
        [
            'label' => esc_html__( 'Tab Content Padding', 'turitor' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .turitor-tab .ts-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

    $this->end_controls_section();  

   } 

   	protected function render( ) { 
      $settings       = $this->get_settings();
      $tabs_items     = $settings['turitor_tab_items'];

      
     if ( $tabs_items ) {
   ?>

    <div class="turitor-tab">
        <div class="container-fluid">
            <div class="row no-gutters justify-content-end">
                <div class="col-lg-9">
                   <div class="row no-gutters">
                        <div class="col-lg-4">
                                <ul class="nav turitor-navs-tab nav-tabs" role="tablist">
                                <!-- list item --> 
                                <?php 
                                    foreach($tabs_items as $key_tab=> $nav_tabs){
                                        $turitor_nav_title          = $nav_tabs['turitor_nav_title'];
                                        $turitor_nav_sub_title      = $nav_tabs['turitor_nav_sub_title'];
                                        $turitor_tab_title_icons    = $nav_tabs['turitor_tab_title_icons'];
                                ?>
                                <li class="tab-list">
                                    <a class="<?php echo esc_attr($key_tab==0?'active':''); ?>" data-toggle="tab" href="#turitor-tab-<?php echo esc_attr($key_tab).'-'.esc_attr($this->get_id()); ?>" role="tab" aria-controls="turitor-tab-<?php echo esc_attr($this->get_id()); ?>" aria-selected="true">
                                        <div class="title-content d-flex">
                                            
                                            <div class="title-icon">
                                                <?php Icons_Manager::render_icon( $turitor_tab_title_icons, [ 'aria-hidden' => 'true' ] ); ?>
                                            </div>
                                           
                                            <div class="content">
                                                <?php if($turitor_nav_title != ''): ?> 
                                                   <strong> <?php echo esc_html($turitor_nav_title); ?> </strong>
                                                <?php 
                                                    endif; 
                                                    if($turitor_nav_sub_title != ''):
                                                ?>
                                                <span>
                                                    <?php echo esc_html($turitor_nav_sub_title); ?> 
                                                 </span>
                                                <?php endif; ?> 
                                            </div>
                                        </div>
                                    </a>
                                </li>
                                <?php } ?>
                                <!-- list item end  -->
                            </ul>
                        </div><!-- col end -->
                        <div class="col-lg-8">
                            <div class="tab-content ts-tab-content">
                            <?php foreach($tabs_items as $key_content=> $tabs_content){ 
                                $turitor_tab_content = $tabs_content['turitor_tab_content'];

                            ?>
                                <!-- tab start --> 
                                <div  class="tab-pane fade <?php echo esc_attr($key_content==0?"show active":''); ?>" id="turitor-tab-<?php echo esc_attr($key_content).'-'.esc_attr($this->get_id()); ?>" role="tabpanel">
                                    <?php if(isset($tabs_content['tab_bg']) && $tabs_content['tab_bg']['url'] !=''): ?>
                                        <div class="tab-bg" style="background-image: url(<?php echo esc_url($tabs_content['tab_bg']['url']); ?>);"> </div>
                                    <?php endif; ?>
                                    <div class="tab-content">
                                       <?php echo turitor_kses($turitor_tab_content); ?> 
                                    </div>
                                </div>
                                <!-- Tab end --> 
                            <?php } ?>
                            </div>
                        </div><!-- col end --> 
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php  
    }}
    protected function _content_template() { }
}