<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Turitor_tutor_Course_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'turitor-tutor-course';
    }

    public function get_title() {

        return esc_html__( 'Tutor Course', 'turitor' );

    }

    public function get_icon() { 
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return [ 'turitor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Tutor Course', 'turitor' ),
				
			]
		);

		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Course Style', 'turitor' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1'  => esc_html__( 'Style 1', 'turitor' ),
					'style2'  => esc_html__( 'Style 2', 'turitor' ),
					
				],
			]
         );

		$this->add_control(
			'post_limit',
			[
				'label'   => esc_html__( 'Post Count', 'turitor' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
				'min'     => 1,
				'step'    => 1,
			]
		);

		$this->add_control(
			'grid_column',
			[
				'label'   => esc_html__( 'Number Column', 'turitor' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'6'     => esc_html__( '2', 'turitor' ),
					'4'       => esc_html__( '3', 'turitor' ),
					'3' => esc_html__( '4', 'turitor' ),
				],
				'default' => '3',
				'condition' => ['style' => ['style2']],
			]
		);
		
		$this->add_control(
			'cat_id',
			[
			  'label'     => esc_html__( 'Select Category', 'turitor' ),
			  'type'      => Controls_Manager::SELECT2,
			   'options'   => $this->course_category(),
			  'multiple' =>true,
			  'label_block' => true,
			]
		);
		$this->end_controls_section();

		
		$this->start_controls_section(
			'section_style', [
				'label'	 => esc_html__( 'Course Style', 'turitor' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'title_typography',
					'label'		 => esc_html__("Title Typography",'turitor'),
					'selector'	 => '{{WRAPPER}} .single-course .ts-course-el-title',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(), [
					'name'		 => 'desc_typography',
					'label'		 => esc_html__("Description Typography",'turitor'),
					'selector'	 => '{{WRAPPER}} .single-course-item .single-course .excerpt-content p',
				]
			);
			$this->end_controls_section();
		
		}

    protected function render( ) { 

		$settings = $this->get_settings();
		$column = $settings['grid_column'];
		$cat_id = $settings['cat_id'];
		$post_limit = $settings['post_limit'];


		if($settings['style']=='style1'):  

			$category_ids = $cat_id;
			$cat_ids =  implode(', ', $category_ids);

			echo do_shortcode("[tutor_course category='$cat_ids' count='$post_limit']");
		endif;

		if($settings['style']=='style2'):   
			include (locate_template("components/editor/elementor/widgets/style/courses/tutor-lms-course-style2.php", false, false ));  
		endif;

		
		
	}
	protected function _content_template() { }

	public function course_category(){
		if ( ! function_exists('tutor')) {
			return [];
		}
		$tax_terms = get_terms('course-category', array('hide_empty' => false));
		$category_list = [];
		 
		foreach($tax_terms as $term_single) {      
			$category_list[$term_single->term_id] = [$term_single->name];
		 
		}
	  
		return $category_list;
	  }

}