<?php



function turitor_filter_courses_by_attributes($query)
{
	global $wp_query;

	if (!defined('LP_COURSE_CPT')) {
		return $query;
	}

	if (!$query->is_main_query()) {
		return $query;
	}

	if (!is_post_type_archive(LP_COURSE_CPT)) {
		return $query;
	}

	return $query;
}

add_filter('pre_get_posts', 'turitor_filter_courses_by_attributes', 1001, 1);

//turitor course archive template file load

function turitor_page_template($template)
{
	$category = get_queried_object();

	if (!function_exists('learn_press_is_course_archive')) {
		return $template;
	}

	if (learn_press_is_course_archive() || (isset($category->taxonomy) && $category->taxonomy == 'ts-skill-label')) {

		if (file_exists(TURITOR_THEME_DIR . '/course-archive.php')) {
			return TURITOR_THEME_DIR . '/course-archive.php';
		}
	}


	return $template;
}
add_filter('template_include', 'turitor_page_template', 999);



function turitor_filter_archive($args)
{
	if (!function_exists('learn_press_is_course_archive')) {
		return $template;
	}
	// search
	if (isset($_REQUEST['ref']) && $_REQUEST['ref'] == 'course') {
		$args['s'] = sanitize_text_field($_REQUEST['s']);
	}

	$post_in =  turitor_course_popular_ids();

	if (isset($_REQUEST['orderBy'])) {

		if ($_REQUEST['orderBy'] == 'alphabetical') {
			$args['orderby'] = 'title';
			$args['order']   = 'ASC';
		} elseif ($_REQUEST['orderBy'] == 'newly-published') {
			$args['orderby'] = 'post_date';
			$args['order']   = 'DESC';
		} elseif ($_REQUEST['orderBy'] == 'feature') {
			$args['meta_query'] = array(
				array(
					'key' => '_lp_featured',
					'value' =>  'yes',
				)
			);
		} elseif ($_REQUEST['orderBy'] == 'popularity' && is_array($post_in)) {
			$args['post__in'] = $post_in;
			$args['orderby']  = 'post__in';
		}
	}
	//filter 
	$category = get_queried_object();
	if (learn_press_is_course_archive() || (isset($category->taxonomy) && $category->taxonomy == 'ts-skill-label')) {


		if (isset($category->taxonomy) && $category->taxonomy == 'course_category') {

			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_category',
					'field'    => 'term_id',
					'terms'    => array($category->term_id),
				),
			);
		} elseif (isset($category->taxonomy) && $category->taxonomy == 'ts-skill-label') {

			$args['tax_query'] = array(
				array(
					'taxonomy' => 'ts-skill-label',
					'field'    => 'term_id',
					'terms'    => array($category->term_id),
				),
			);
		}
	}

	return $args;
}
add_filter('turitor_archive_post_args', 'turitor_filter_archive', 99);

function turitor_press_back_to_course_button()
{
	$courses_link = learn_press_get_page_link('courses');
	if (!$courses_link) {
		return;
	}
?>

	<a href="<?php echo esc_url(learn_press_get_page_link('courses')); ?>"><?php esc_html__('Back to course', 'turitor'); ?></a>
<?php
}
add_action('turitor/after-checkout-form', 'turitor_press_back_to_course_button');
add_action('turitor/after-empty-cart-message', 'turitor_press_back_to_course_button');


if(defined('LP_COURSE_CPT')){

	// Learnpress login shortcod
	add_shortcode('turitor_lp_login_form', 'turito_learnpress_login_form');
	function turito_learnpress_login_form()
	{
		if(is_admin()) return;
		if(is_user_logged_in()) return;
		$profile = LP_Global::profile();
		$profile_url = learn_press_get_page_link('profile');
	?>
	
		<div class="learn-press-form-login learn-press-form">
	
			<h3><?php echo _x('Login', 'login-heading', 'turitor'); ?></h3>
	
			<?php do_action('learn-press/before-form-login'); ?>
	
			<form name="learn-press-login" method="post" action="<?php echo esc_url($profile_url); ?>">
	
				<?php do_action( 'learn-press/before-form-login-fields' ); ?>
	
				<ul class="form-fields">
					<li class="form-field">
						<label for="username"><?php esc_html_e( 'Username or email', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
						<input type="text" name="username" id="username" placeholder="<?php esc_attr_e( 'Email or username', 'turitor' ); ?>" autocomplete="username" />
					</li>
					<li class="form-field">
						<label for="password"><?php esc_html_e( 'Password', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
						<input type="password" name="password" id="password" placeholder="<?php esc_attr_e( 'Password', 'turitor' ); ?>" autocomplete="current-password" />
					</li>
				</ul>
	
				<?php do_action( 'learn-press/after-form-login-fields' ); ?>
				<p>
					<label>
						<input type="checkbox" name="rememberme"/>
						<?php esc_html_e( 'Remember me', 'turitor' ); ?>
					</label>
				</p>
				<p>
					<input type="hidden" name="learn-press-login-nonce" value="<?php echo wp_create_nonce( 'learn-press-login' ); ?>">
					<p class="login-btn">
						<button type="submit" class="btn btn-primary"><?php esc_html_e( 'Login', 'turitor' ); ?></button>
					</p>
				</p>
				<p>
					<a href="<?php echo wp_lostpassword_url(); ?>"><?php esc_html_e( 'Lost your password?', 'turitor' ); ?></a>
				</p>
			</form>
	
			<?php do_action('learn-press/after-form-login'); ?>
	
		</div>
	<?php
	}
	
	
	
	// learnpress register form
	add_shortcode('turitor_lp_register_form', 'turitor_learnpress_register_form');
	
	function turitor_learnpress_register_form(){
		if(is_admin()) return;
		if(is_user_logged_in()) return;
		$profile = LP_Global::profile();
		$profile_url = learn_press_get_page_link('profile');
	?>
	
	<div class="learn-press-form-register learn-press-form">
	
		<h3><?php echo _x( 'Register', 'register-heading', 'turitor' ); ?></h3>
	
		<?php do_action( 'learn-press/before-form-register' ); ?>
	
		<form name="learn-press-register" method="post" action="<?php echo esc_url($profile_url);?>">
	
			<ul class="form-fields">
	
				<?php do_action( 'learn-press/before-form-register-fields' ); ?>
	
				<li class="form-field">
					<label for="reg_email"><?php esc_html_e( 'Email address', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
					<input id ="reg_email" name="reg_email" type="text" placeholder="<?php esc_attr_e( 'Email', 'turitor' ); ?>" autocomplete="email" value="<?php echo ( ! empty( $_POST['reg_email'] ) ) ? esc_attr( wp_unslash( $_POST['reg_email'] ) ) : ''; ?>">
				</li>
				<li class="form-field">
					<label for="reg_username"><?php esc_html_e( 'Username', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
					<input id ="reg_username" name="reg_username" type="text" placeholder="<?php esc_attr_e( 'Username', 'turitor' ); ?>" autocomplete="username" value="<?php echo ( ! empty( $_POST['reg_username'] ) ) ? esc_attr( wp_unslash( $_POST['reg_username'] ) ) : ''; ?>">
				</li>
				<li class="form-field">
					<label for="reg_password"><?php esc_html_e( 'Password', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
					<input id ="reg_password" name="reg_password" type="password" placeholder="<?php esc_attr_e( 'Password', 'turitor' ); ?>" autocomplete="new-password">
				</li>

				<li class="form-field">
					<label for="reg_password2"><?php esc_html_e( 'Confirm Password', 'turitor' ); ?>&nbsp;<span class="required">*</span></label>
					<input id ="reg_password2" name="reg_password2" type="password" placeholder="<?php esc_attr_e( 'Confirm Password', 'turitor' ); ?>" autocomplete="off">
				</li>
	
				<?php do_action( 'learn-press/after-form-register-fields' ); ?>
			</ul>
	
			<?php do_action( 'register_form' ); ?>
	
			<p class="login-btn">
				<?php wp_nonce_field( 'learn-press-register', 'learn-press-register-nonce' ); ?>
				<button type="submit" class="btn btn-primary"><?php esc_html_e( 'Register', 'turitor' ); ?></button>
			</p>
	
		</form>
	
		<?php do_action( 'learn-press/after-form-register' ); ?>
	
	</div>
	<?php 
	}
	}
if(defined('LP_COURSE_CPT')){
	function check_user_role($roles, $user_id = null) {
		if ($user_id) $user = get_userdata($user_id);
		else $user = wp_get_current_user();
		if (empty($user)) return false;
		foreach ($user->roles as $role) {
			if (in_array($role, $roles)) {
				return true;
			}
		}
		return false;
	}
}