<?php

function turitor_fw_ext_backups_demos( $demos ) {

	$demo_content_installer	 = 'https://demo.themewinter.com/wp/demo-content/turitor';
	$demos_array			 = array(
		    'default'			 => array(
				'title'			 => esc_html__( 'LearnPress Main Demo (1-6)', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/default/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
			'classic'			 => array(
				'title'			 => esc_html__( 'LearnPress Classic', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/classic/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
			'homertl'			 => array(
				'title'			 => esc_html__( 'LearnPress Default RTL Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/homertl/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
			'tutor'			 => array(
				'title'			 => esc_html__( 'Tutor LMS Main Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/tutor/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
			'tutor_classic'			 => array(
				'title'			 => esc_html__( 'Tutor LMS Classic Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/tutor_classic/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
			'learndash'			 => array(
				'title'			 => esc_html__( 'Learndash Main Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/learndash/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),

			'learndash_classic'			 => array(
				'title'			 => esc_html__( 'Learndash Classic Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/learndash_classic/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),


			
			'education'			 => array(
				'title'			 => esc_html__( 'University Demo (1-2)', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/education/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
		    'kindergarten'			 => array(
				'title'			 => esc_html__( 'Kindergarten Demo', 'turitor' ),
				'screenshot'	 => esc_url( $demo_content_installer ) . '/kindergarten/screenshot.png',
				'preview_link'	 => esc_url( 'https://themeforest.net/user/tripples/portfolio' ),
			),
	);
	
	$download_url = esc_url( $demo_content_installer ) . '/manifest.php';
	foreach ( $demos_array as $id => $data ) {
		$demo						 = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
			'url'		 => $download_url,
			'file_id'	 => $id,
		) );
		$demo->set_title( $data[ 'title' ] );
		$demo->set_screenshot( $data[ 'screenshot' ] );
		$demo->set_preview_link( $data[ 'preview_link' ] );
		$demos[ $demo->get_id() ]	 = $demo;
		unset( $demo );
	}

	return $demos;
}

add_filter( 'fw:ext:backups-demo:demos', 'turitor_fw_ext_backups_demos' );

function turitor_after_succeess_restore_demo($obj) {

	if(method_exists($obj, 'get_id')){
		// this tables data will be export and import
		$tutitor_tables = ['users','usermeta'];
		
		global $wp_filesystem;
    	require_once ( ABSPATH . '/wp-admin/includes/file.php' );
		WP_Filesystem();
	
		$id = $obj->get_id();
		$title = $obj->get_title();
		
		// content backup after success action
		if($id == 'full-backup' || $id=='content-backup') {
			
			$demo_file_path =  TURITOR_CORE.  '/installation-fragments/demo.txt';
			$turitor_demo_data = turitor_demo_data_export($tutitor_tables);
			$content = $wp_filesystem->put_contents( $demo_file_path, $turitor_demo_data);
		
		}

		// after demo install success action
		if($id=='demo-content-install'){
			
		     	$remote_demo_file = 'https://demo.themewinter.com/wp/demo-content/turitor/demo.txt';
				if ( turitor_remote_file_exists($remote_demo_file) ) {
					
					$request = turitor_get_remote_demo_data($remote_demo_file);
					if( !is_wp_error( $request ) ) {
						$body = wp_remote_retrieve_body( $request );
						$return_data = turitor_demo_content_unserialize($body);
					}

					if(is_array($return_data) && count($return_data)){
						turitor_database_table_data_import($return_data);
					}
			    }		
		} 

	}
	
	return $obj;
}

add_action('fw:ext:backups:tasks:success','turitor_after_succeess_restore_demo');






