<?php

	/**
	 * Prevent loading this file directly
	 */
   defined( 'ABSPATH' ) || exit();
	$course_order_by = 'DESC';
	if ( defined( 'FW' ) ) { 
		$course_order_by = turitor_option('course_order_by');
	}


   $paged    = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
   $args = array( 
		'post_type' => LP_COURSE_CPT,
		'orderby' => 'modified',
		'order' => $course_order_by,
		'posts_per_page' => LP()->settings->get('learn_press_archive_course_limit') ,
		'paged' => $paged 
	);

	$args = apply_filters('turitor_archive_post_args',$args);

	$query = new WP_Query($args);
	
	$total = $query->found_posts;
	if ( $total == 0 ) {
		$message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'turitor' ) . '</p>';
		$index   = esc_html__( 'There are no available courses!', 'turitor' );
	} elseif ( $total == 1 ) {
		$index = esc_html__( 'Showing only one result', 'turitor' );
	} else {
		$courses_per_page = absint( LP()->settings->get( 'archive_course_limit' ) );
		
		$from = 1 + ( $paged - 1 ) * $courses_per_page;
		$to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

		if ( $from == $to ) {
			$index = sprintf(
				esc_html__( 'Showing last course of %s results', 'turitor' ),
				$total
			);
		} else {
			$index = sprintf(
				esc_html__( 'Showing %s-%s of %s results', 'turitor' ),
				$from,
				$to,
				$total
			);
		}
	}

	$course_layout_advanced_settings = turitor_option('course_layout_settings','[]');
	$search      = 'yes'; 
	$latest_post = 'yes'; 
	$category    = 'yes'; 
	$skill       = 'yes'; 
	
	if(isset($course_layout_advanced_settings['advanced'])){

		$advanced    = $course_layout_advanced_settings['advanced'];
		$search      = isset($advanced['search'])?$advanced['search']:'no';
		$latest_post = isset($advanced['latest_post'])?$advanced['latest_post']:'no';
		$category    = isset($advanced['category'])?$advanced['category']:'no';
		$skill       = isset($advanced['skill'])?$advanced['skill']:'no';
		
	} 
	?>
	<div class="row">
       <div class="col-md-5 col-lg-3">
				<div class="course-sidebar">
					<?php 
					
						if($search=='yes'){
						   get_template_part( 'learnpress/search', 'form' ); 
						}

					?>
					<?php

						if($category=='yes'){ ?>

							<div class="archive-category-filter-area archive-widgets">
									<h3 class="widget-title archive-cat-title"><?php echo esc_html__('All categories', 'turitor'); ?> <i class="fa fa-angle-down"></i></h3>
								<?php get_template_part('learnpress/filter','category'); ?>
							</div>

						<?php
						} 

					?>
					<?php
					if($skill == 'yes'){
					?>
					<div class="archive-skill-filter-area archive-widgets">
						<h3 class="widget-title archive-skill-title"><?php echo esc_html__('Skill level', 'turitor'); ?> <i class="fa fa-angle-down"></i></h3>
					<?php get_template_part('learnpress/filter','skill'); ?>
					</div>
					<?php
					}
					?>
					<?php
						if($latest_post=='yes'){
							?>
							<div class="archive-widgets">
								<?php	get_template_part('learnpress/latest','post'); ?>
							</div>
							<?php
						}   
					?>
				</div>
	    </div>
		<div class="col-md-7 col-lg-9 course-archive-styel2">
		    <div class="row archive-course-filter mb-40"> 
			     <div class="col-md-6 align-self-center">
						<p class="text-index-result">
						   <?php echo esc_html($index); ?> 
						</p>
				  </div> 
			     <div class="col-md-6 text-right"> 
				     <?php get_template_part('learnpress/filter','order'); ?>
				 </div> 
			</div>
		     <div class="row">
				<?php 
					if($query->have_posts()):
						while ($query->have_posts()) : $query->the_post();
							get_template_part( 'learnpress/content-course', 'advance' ); 
						endwhile;
						wp_reset_postdata();
					endif;
				?> 
			</div>
			<?php
				$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 
				get_template_part( 'template-parts/blog/paginations/pagination', 'style1' );
			?>
	   </div>
	</div>
	<?php

	