<?php

    defined( 'ABSPATH' ) || exit();

    $course          = LP_Global::course();
    $instructor      = $course->get_instructor();
    $instructor_link = $course->get_instructor_html();
    $instructor_id   = $course->get_id();

?>

<div class="course-single-wrap archive-course2 col-lg-4"> 
 
         <div class="single-course mb-30">
            <div class="course-thumbnail">
               <?php $course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' ); ?>
                  <?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
                           <img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo the_title_attribute(); ?>">
                  <?php }else{ ?>
                     <img class="img-fluid" src="<?php echo  esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php echo the_title_attribute(); ?>">
               <?php } ?> 
            </div>
            <div class="course-price-item">
                  <?php if($course->is_free()): ?>
                    <span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
                  <?php else: ?>
                  <span class="course-price">							
                     <?php echo turitor_kses($course->get_price_html()); ?>
                  </span>   
                  <?php endif; ?>
               </div>

            <div class="course-category">
                  <?php 
                     echo wp_kses_post(turitor_course_cageory_by_id(get_the_id()));
                     ?> 
            </div>
            <h3 class="ts-course-el-title"> 
                  <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
            </h3>
            <div class="enrol-list-area">
               <ul class="course-enrole-list">
                  <li class="lessons">
                     <i class="tsicon tsicon-file"></i> 
                     <?php   $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
                            echo esc_html($lessons). esc_html__(' lessons','turitor'); 
                         ?>
                  </li>
                  <li class="students">
                        <i class="tsicon tsicon-user_group"></i> 
                        <?php echo esc_html($course->count_students()); ?> 
                  </li>
               </ul>
            </div>
            <div class="border-bar"></div>
            <div class="course-footer">
               <?php 
                  if(defined('WUR_REVIEW_KEY')) {
                     echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'no', 'vote-text' => '', 'return-type' => '' ]);
                  }
               ?>
               <a href="<?php echo esc_url($course->get_permalink()); ?>" class="btn-link"><i class="tsicon tsicon-right_arrow"></i></a>
            </div>
         </div>

 </div>