<?php

    defined( 'ABSPATH' ) || exit();

    $course          = LP_Global::course();
    $instructor      = $course->get_instructor();
    $instructor_link = $course->get_instructor_html();
    $instructor_id   = $course->get_id();

?>

<div class="archive-course col-lg-4 col-md-6"> 
    <div class="single-course mb-30">
                <p class="course-category">
                    <?php
                       echo wp_kses_post(turitor_course_cageory_by_id(get_the_id()));
                    ?>
                </p>
                <h3 class="ts-course-el-title">
                    <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
                </h3>
                <div class="enrol-list-area">
                    <ul class="course-enrole-list">
                        <li class="lessons">
                            <i class="tsicon tsicon-file"></i> 
                            <?php   
                                $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
                                echo esc_html($lessons). esc_html__(' lessons','turitor'); 
                              ?>
                        </li>
                        <li class="students">
                            <i class="tsicon tsicon-user_group"></i> 
                            <?php echo esc_html($course->get_users_enrolled()); ?> 
                        </li>
                    </ul>
                    <div class="instructor">  
                        <?php 
                            $dir = learn_press_user_profile_picture_upload_dir();
                            $user = get_user_by( 'id', $instructor->get_id());
                            $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
                            $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
                            $profile_link =  $base_url.'/'.$pro_link;
                        ?>
                    
                        <?php if($pro_link !=''){ ?>
                            <div class="instructor-thumb">
                                <img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                            </div>
                            <?php  echo wp_kses_post($instructor_link) ?>

                    <?php }else{ ?>
                            <div class="instructor-thumb">
                                <img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?> " alt="<?php echo esc_attr($user->display_name); ?>"> 
                            </div>
                            <?php  echo wp_kses_post($instructor_link) ?>
                        <?php } ?>
                    </div>
                            

                </div>




                <div class="course-thumb">
                    <?php $course_intro_img = turitor_meta_option( $post->ID,'course_intro_img' ); ?>
                        <?php if(isset($course_intro_img['url']) && $course_intro_img['url'] !=''){ ?>
                                <img class="img-fluid"  src="<?php echo esc_url($course_intro_img['url']); ?>" alt="<?php echo the_title_attribute(); ?>">
                        <?php }else{ ?>
                            <img class="img-fluid" src="<?php echo  esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php echo the_title_attribute(); ?>">
                    <?php } ?> 
                </div>
                <img class="course-shap" src="<?php echo esc_url_raw(TURITOR_IMG.'/shape_combined.svg');  ?>" alt="<?php echo esc_attr__('shape', 'turitor'); ?>">

                <div class="course-footer">
                    <?php 
                        if(defined('WUR_REVIEW_KEY')) {
                            echo	review_kit_rating( [ 'post-id' => $post->ID, 'ratting-show' => 'yes', 'ratting-style' => 'star', 'count-show' => 'no', 'vote-show' => 'yes', 'vote-text' => 'votes', 'return-type' => '' ]);
                        }
                    ?>
                    <div class="course-price-item">
                            <?php if($course->is_free()): ?>
                            <span class="free-course"> <?php echo esc_html__('Free','turitor'); ?> </span> 
                            <?php else: ?>
                            <span class="course-price">							
                                <?php echo turitor_kses($course->get_price_html()); ?>
                            </span> 
                            <?php endif; ?>
                    </div>
                </div>
    </div>
  
</div>

