<?php
/**
 * Template for displaying main user profile page.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.0
 */

defined( 'ABSPATH' ) || exit();

if ( ! isset( $profile ) ) {
	return;
}
?>
<?php

$user = get_user_by( 'slug', get_query_var( 'user') );

$user_meta =get_userdata($user->ID);
$user_roles =[];

if(!empty($user_meta)){
	$user_roles = $user_meta->roles;
}

do_action( 'learnpress/template/pages/profile/before-content' );

if( in_array('lp_teacher',$user_roles ) && !is_user_logged_in()){
	get_template_part( 'learnpress/profile', 'instructor' );
}else{
	?>
	<div class="container user-dashboard">
		<div id="learn-press-profile" <?php $profile->main_class(); ?>>
			<?php if ( $profile->is_public() || $profile->get_user()->is_guest() ) : ?>
				<div class="wrapper-profile-header wrap-fullwidth">
					<?php do_action( 'learn-press/before-user-profile', $profile ); ?>
				</div>

				<div class="lp-content-area">
					<?php
					if ( ! is_user_logged_in() ) {
						learn_press_print_messages( true );
					}

					/**
					 * @since 3.0.0
					 */
					do_action( 'learn-press/user-profile', $profile );
					?>
				</div>
			<?php else : ?>
				<div class="lp-content-area">
					<?php esc_html_e( 'This user does not public their profile.', 'learnpress' ); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
<?php
}

do_action( 'learnpress/template/pages/profile/after-content' );
