<?php
/**
 * Template for displaying courses
 *
 * @since v.1.0.0
 *
 * @author Themeum
 * @url https://themeum.com
 *
 * @package TutorLMS/Templates
 * @version 1.4.3
 */

get_header(); 

get_template_part( 'template-parts/banner/content', 'banner-blog' );
$turitor_course_layout = turitor_option('course_layout_style', 'standard');
if (isset($_GET['theme'])) {
	$turitor_course_layout =  sanitize_text_field($_GET['theme']);
 }
?>

	<div class="<?php tutor_container_classes() ?>">

		<?php if ($turitor_course_layout == 'advanced') { 
				get_template_part("tutor/tutor-lms-course","style2"); 
			}
			else if($turitor_course_layout == 'solid'){
				get_template_part("tutor/tutor-lms-course","style3");
			}
			else { ?>
		<?php
		do_action('tutor_course/archive/before_loop');

		if ( have_posts() ) :
			/* Start the Loop */

			tutor_course_loop_start();

			while ( have_posts() ) : the_post();
				/**
				 * @hook tutor_course/archive/before_loop_course
				 * @type action
				 * Usage Idea, you may keep a loop within a wrap, such as bootstrap col
				 */
				do_action('tutor_course/archive/before_loop_course');

				tutor_load_template('loop.course');

				/**
				 * @hook tutor_course/archive/after_loop_course
				 * @type action
				 * Usage Idea, If you start any div before course loop, you can end it here, such as </div>
				 */
				do_action('tutor_course/archive/after_loop_course');
			endwhile;

			tutor_course_loop_end();

		else :

			/**
			 * No course found
			 */
			tutor_load_template('course-none');

		endif;
		// tutor_archive_course_add_to_cart();

	}

		tutor_course_archive_pagination();

		/**
		 * Required loggedin form popup
		 * @since v 1.5.5
		 */

		do_action('tutor_course/archive/after_loop');
		?>
	</div><!-- .wrap -->
 
<?php get_footer();
