<?php
/**
 * @package TutorLMS/Templates
 * @version 1.4.3
 */

global $post, $authordata;

$profile_url = tutor_utils()->profile_url($authordata->ID);
?>


<div class="tutor-course-loop-meta">
    <?php
    $course_duration = get_tutor_course_duration_context();
    $course_students = tutor_utils()->count_enrolled_users_by_course();
    if(!empty($course_duration)) { ?>
        <div class="tutor-single-loop-meta">
            <i class='tutor-icon-clock'></i> <span><?php echo $course_duration; ?></span>
        </div>
    <?php } ?>

    <div class="tutor-single-loop-meta">
        <i class='tutor-icon-user'></i><span><?php echo $course_students; ?></span>
    </div>
</div>

<div class="tutor-loop-author">
    <div class="tutor-single-course-avatar">
        <a href="<?php echo $profile_url; ?>"> <?php echo tutor_utils()->get_tutor_avatar($post->post_author); ?></a>
    </div>
    <div class="tutor-single-course-author-name">
        <span><?php esc_html_e('by', 'turitor'); ?></span>
        <a href="<?php echo $profile_url; ?>"><?php echo get_the_author(); ?></a>
    </div>
</div>
