<?php
/**
 * The template for displaying archive of meetings
 *
 * This template can be overridden by copying it to yourtheme/video-conferencing-zoom/archive-meetings.php.
 *
 * @author Deepen
 * @since 3.0.0
 */

defined( 'ABSPATH' ) || exit;

get_header();
get_template_part('template-parts/banner/content', 'banner-blog');

$turitor_blog_sidebar = turitor_option('blog_sidebar',3); 
$turitor_column = ($turitor_blog_sidebar == 1 || !is_active_sidebar('sidebar-1')) ? 'col-lg-8 mx-auto' : 'col-lg-8 col-md-12';

?>
<section id="main-content" class="blog main-container" role="main">
	<div class="container">
		<div class="row">
      <?php if($turitor_blog_sidebar == 2){
				get_sidebar();
			  }  ?>
			<div class="<?php echo esc_attr($turitor_column);?>">
				
					<div id="dpn-zvc-primary" class="dpn-zvc-primary container">
							<?php if ( have_posts() ) {
							// Start the Loop.
							while ( have_posts() ) {
								the_post();

								vczapi_get_template_part( 'content', 'meeting' );
							}
						} else {
							echo "<p>" . esc_html__( 'No Meetings found.', 'turitor' ) . "</p>";
						}
						?>
					</div>
			</div><!-- .col-md-8 -->

			<?php if($turitor_blog_sidebar == 3){
				get_sidebar();
			  }  ?>
		</div><!-- .row -->
	</div><!-- .container -->
</section><!-- #main-content -->


<?php
get_footer();
